/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for AccountIdentifier.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountIdentifier extends com.google.api.client.json.GenericJson {

  /**
   * The aggregator ID, set for aggregators and subaccounts (in that case, it represents the
   * aggregator of the subaccount).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger aggregatorId;

  /**
   * The merchant account ID, set for individual accounts and subaccounts.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger merchantId;

  /**
   * The aggregator ID, set for aggregators and subaccounts (in that case, it represents the
   * aggregator of the subaccount).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getAggregatorId() {
    return aggregatorId;
  }

  /**
   * The aggregator ID, set for aggregators and subaccounts (in that case, it represents the
   * aggregator of the subaccount).
   * @param aggregatorId aggregatorId or {@code null} for none
   */
  public AccountIdentifier setAggregatorId(java.math.BigInteger aggregatorId) {
    this.aggregatorId = aggregatorId;
    return this;
  }

  /**
   * The merchant account ID, set for individual accounts and subaccounts.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getMerchantId() {
    return merchantId;
  }

  /**
   * The merchant account ID, set for individual accounts and subaccounts.
   * @param merchantId merchantId or {@code null} for none
   */
  public AccountIdentifier setMerchantId(java.math.BigInteger merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  @Override
  public AccountIdentifier set(String fieldName, Object value) {
    return (AccountIdentifier) super.set(fieldName, value);
  }

  @Override
  public AccountIdentifier clone() {
    return (AccountIdentifier) super.clone();
  }

}
