/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Overall impact of the issue.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountIssueImpact extends com.google.api.client.json.GenericJson {

  /**
   * Detailed impact breakdown. Explains the types of restriction the issue has in different
   * shopping destinations and territory. If present, it should be rendered to the merchant. Can be
   * shown as a mouse over dropdown or a dialog. Each breakdown item represents a group of regions
   * with the same impact details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Breakdown> breakdowns;

  /**
   * Optional. Message summarizing the overall impact of the issue. If present, it should be
   * rendered to the merchant. For example: "Disapproves 90k offers in 25 countries"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String message;

  /**
   * The severity of the issue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String severity;

  /**
   * Detailed impact breakdown. Explains the types of restriction the issue has in different
   * shopping destinations and territory. If present, it should be rendered to the merchant. Can be
   * shown as a mouse over dropdown or a dialog. Each breakdown item represents a group of regions
   * with the same impact details.
   * @return value or {@code null} for none
   */
  public java.util.List<Breakdown> getBreakdowns() {
    return breakdowns;
  }

  /**
   * Detailed impact breakdown. Explains the types of restriction the issue has in different
   * shopping destinations and territory. If present, it should be rendered to the merchant. Can be
   * shown as a mouse over dropdown or a dialog. Each breakdown item represents a group of regions
   * with the same impact details.
   * @param breakdowns breakdowns or {@code null} for none
   */
  public AccountIssueImpact setBreakdowns(java.util.List<Breakdown> breakdowns) {
    this.breakdowns = breakdowns;
    return this;
  }

  /**
   * Optional. Message summarizing the overall impact of the issue. If present, it should be
   * rendered to the merchant. For example: "Disapproves 90k offers in 25 countries"
   * @return value or {@code null} for none
   */
  public java.lang.String getMessage() {
    return message;
  }

  /**
   * Optional. Message summarizing the overall impact of the issue. If present, it should be
   * rendered to the merchant. For example: "Disapproves 90k offers in 25 countries"
   * @param message message or {@code null} for none
   */
  public AccountIssueImpact setMessage(java.lang.String message) {
    this.message = message;
    return this;
  }

  /**
   * The severity of the issue.
   * @return value or {@code null} for none
   */
  public java.lang.String getSeverity() {
    return severity;
  }

  /**
   * The severity of the issue.
   * @param severity severity or {@code null} for none
   */
  public AccountIssueImpact setSeverity(java.lang.String severity) {
    this.severity = severity;
    return this;
  }

  @Override
  public AccountIssueImpact set(String fieldName, Object value) {
    return (AccountIssueImpact) super.set(fieldName, value);
  }

  @Override
  public AccountIssueImpact clone() {
    return (AccountIssueImpact) super.clone();
  }

}
