/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The return carrier information. This service is designed for merchants enrolled in the Buy on
 * Google program.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountReturnCarrier extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Immutable. The Google-provided unique carrier ID, used to update the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long carrierAccountId;

  /**
   * Name of the carrier account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String carrierAccountName;

  /**
   * Number of the carrier account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String carrierAccountNumber;

  /**
   * The carrier code enum. Accepts the values FEDEX or UPS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String carrierCode;

  /**
   * Output only. Immutable. The Google-provided unique carrier ID, used to update the resource.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCarrierAccountId() {
    return carrierAccountId;
  }

  /**
   * Output only. Immutable. The Google-provided unique carrier ID, used to update the resource.
   * @param carrierAccountId carrierAccountId or {@code null} for none
   */
  public AccountReturnCarrier setCarrierAccountId(java.lang.Long carrierAccountId) {
    this.carrierAccountId = carrierAccountId;
    return this;
  }

  /**
   * Name of the carrier account.
   * @return value or {@code null} for none
   */
  public java.lang.String getCarrierAccountName() {
    return carrierAccountName;
  }

  /**
   * Name of the carrier account.
   * @param carrierAccountName carrierAccountName or {@code null} for none
   */
  public AccountReturnCarrier setCarrierAccountName(java.lang.String carrierAccountName) {
    this.carrierAccountName = carrierAccountName;
    return this;
  }

  /**
   * Number of the carrier account.
   * @return value or {@code null} for none
   */
  public java.lang.String getCarrierAccountNumber() {
    return carrierAccountNumber;
  }

  /**
   * Number of the carrier account.
   * @param carrierAccountNumber carrierAccountNumber or {@code null} for none
   */
  public AccountReturnCarrier setCarrierAccountNumber(java.lang.String carrierAccountNumber) {
    this.carrierAccountNumber = carrierAccountNumber;
    return this;
  }

  /**
   * The carrier code enum. Accepts the values FEDEX or UPS.
   * @return value or {@code null} for none
   */
  public java.lang.String getCarrierCode() {
    return carrierCode;
  }

  /**
   * The carrier code enum. Accepts the values FEDEX or UPS.
   * @param carrierCode carrierCode or {@code null} for none
   */
  public AccountReturnCarrier setCarrierCode(java.lang.String carrierCode) {
    this.carrierCode = carrierCode;
    return this;
  }

  @Override
  public AccountReturnCarrier set(String fieldName, Object value) {
    return (AccountReturnCarrier) super.set(fieldName, value);
  }

  @Override
  public AccountReturnCarrier clone() {
    return (AccountReturnCarrier) super.clone();
  }

}
