/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The status of an account, that is, information about its products, which is computed offline and
 * not returned immediately at insertion time.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountStatus extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the account for which the status is reported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountId;

  /**
   * A list of account level issues.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AccountStatusAccountLevelIssue> accountLevelIssues;

  /**
   * How the account is managed. Acceptable values are: - "`manual`" - "`automatic`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountManagement;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#accountStatus`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * List of product-related data by channel, destination, and country. Data in this field may be
   * delayed by up to 30 minutes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AccountStatusProducts> products;

  /**
   * Whether the account's website is claimed or not.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean websiteClaimed;

  /**
   * The ID of the account for which the status is reported.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountId() {
    return accountId;
  }

  /**
   * The ID of the account for which the status is reported.
   * @param accountId accountId or {@code null} for none
   */
  public AccountStatus setAccountId(java.lang.String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * A list of account level issues.
   * @return value or {@code null} for none
   */
  public java.util.List<AccountStatusAccountLevelIssue> getAccountLevelIssues() {
    return accountLevelIssues;
  }

  /**
   * A list of account level issues.
   * @param accountLevelIssues accountLevelIssues or {@code null} for none
   */
  public AccountStatus setAccountLevelIssues(java.util.List<AccountStatusAccountLevelIssue> accountLevelIssues) {
    this.accountLevelIssues = accountLevelIssues;
    return this;
  }

  /**
   * How the account is managed. Acceptable values are: - "`manual`" - "`automatic`"
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountManagement() {
    return accountManagement;
  }

  /**
   * How the account is managed. Acceptable values are: - "`manual`" - "`automatic`"
   * @param accountManagement accountManagement or {@code null} for none
   */
  public AccountStatus setAccountManagement(java.lang.String accountManagement) {
    this.accountManagement = accountManagement;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#accountStatus`"
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#accountStatus`"
   * @param kind kind or {@code null} for none
   */
  public AccountStatus setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * List of product-related data by channel, destination, and country. Data in this field may be
   * delayed by up to 30 minutes.
   * @return value or {@code null} for none
   */
  public java.util.List<AccountStatusProducts> getProducts() {
    return products;
  }

  /**
   * List of product-related data by channel, destination, and country. Data in this field may be
   * delayed by up to 30 minutes.
   * @param products products or {@code null} for none
   */
  public AccountStatus setProducts(java.util.List<AccountStatusProducts> products) {
    this.products = products;
    return this;
  }

  /**
   * Whether the account's website is claimed or not.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWebsiteClaimed() {
    return websiteClaimed;
  }

  /**
   * Whether the account's website is claimed or not.
   * @param websiteClaimed websiteClaimed or {@code null} for none
   */
  public AccountStatus setWebsiteClaimed(java.lang.Boolean websiteClaimed) {
    this.websiteClaimed = websiteClaimed;
    return this;
  }

  @Override
  public AccountStatus set(String fieldName, Object value) {
    return (AccountStatus) super.set(fieldName, value);
  }

  @Override
  public AccountStatus clone() {
    return (AccountStatus) super.clone();
  }

}
