/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * An actionable step that can be executed to solve the issue.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Action extends com.google.api.client.json.GenericJson {

  /**
   * Action implemented and performed in (your) third-party application. The application should
   * point the merchant to the place, where they can access the corresponding functionality or
   * provide instructions, if the specific functionality is not available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BuiltInSimpleAction builtinSimpleAction;

  /**
   * Label of the action button.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String buttonLabel;

  /**
   * Action that is implemented and performed outside of (your) third-party application. The
   * application needs to redirect the merchant to the external location where they can perform the
   * action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ExternalAction externalAction;

  /**
   * Controlling whether the button is active or disabled. The value is 'false' when the action was
   * already requested or is not available. If the action is not available then a reason will be
   * present. If (your) third-party application shows a disabled button for action that is not
   * available, then it should also show reasons.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isAvailable;

  /**
   * List of reasons why the action is not available. The list of reasons is empty if the action is
   * available. If there is only one reason, it can be displayed next to the disabled button. If
   * there are more reasons, all of them should be displayed, for example in a pop-up dialog.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ActionReason> reasons;

  /**
   * Action implemented and performed in (your) third-party application. The application should
   * point the merchant to the place, where they can access the corresponding functionality or
   * provide instructions, if the specific functionality is not available.
   * @return value or {@code null} for none
   */
  public BuiltInSimpleAction getBuiltinSimpleAction() {
    return builtinSimpleAction;
  }

  /**
   * Action implemented and performed in (your) third-party application. The application should
   * point the merchant to the place, where they can access the corresponding functionality or
   * provide instructions, if the specific functionality is not available.
   * @param builtinSimpleAction builtinSimpleAction or {@code null} for none
   */
  public Action setBuiltinSimpleAction(BuiltInSimpleAction builtinSimpleAction) {
    this.builtinSimpleAction = builtinSimpleAction;
    return this;
  }

  /**
   * Label of the action button.
   * @return value or {@code null} for none
   */
  public java.lang.String getButtonLabel() {
    return buttonLabel;
  }

  /**
   * Label of the action button.
   * @param buttonLabel buttonLabel or {@code null} for none
   */
  public Action setButtonLabel(java.lang.String buttonLabel) {
    this.buttonLabel = buttonLabel;
    return this;
  }

  /**
   * Action that is implemented and performed outside of (your) third-party application. The
   * application needs to redirect the merchant to the external location where they can perform the
   * action.
   * @return value or {@code null} for none
   */
  public ExternalAction getExternalAction() {
    return externalAction;
  }

  /**
   * Action that is implemented and performed outside of (your) third-party application. The
   * application needs to redirect the merchant to the external location where they can perform the
   * action.
   * @param externalAction externalAction or {@code null} for none
   */
  public Action setExternalAction(ExternalAction externalAction) {
    this.externalAction = externalAction;
    return this;
  }

  /**
   * Controlling whether the button is active or disabled. The value is 'false' when the action was
   * already requested or is not available. If the action is not available then a reason will be
   * present. If (your) third-party application shows a disabled button for action that is not
   * available, then it should also show reasons.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsAvailable() {
    return isAvailable;
  }

  /**
   * Controlling whether the button is active or disabled. The value is 'false' when the action was
   * already requested or is not available. If the action is not available then a reason will be
   * present. If (your) third-party application shows a disabled button for action that is not
   * available, then it should also show reasons.
   * @param isAvailable isAvailable or {@code null} for none
   */
  public Action setIsAvailable(java.lang.Boolean isAvailable) {
    this.isAvailable = isAvailable;
    return this;
  }

  /**
   * List of reasons why the action is not available. The list of reasons is empty if the action is
   * available. If there is only one reason, it can be displayed next to the disabled button. If
   * there are more reasons, all of them should be displayed, for example in a pop-up dialog.
   * @return value or {@code null} for none
   */
  public java.util.List<ActionReason> getReasons() {
    return reasons;
  }

  /**
   * List of reasons why the action is not available. The list of reasons is empty if the action is
   * available. If there is only one reason, it can be displayed next to the disabled button. If
   * there are more reasons, all of them should be displayed, for example in a pop-up dialog.
   * @param reasons reasons or {@code null} for none
   */
  public Action setReasons(java.util.List<ActionReason> reasons) {
    this.reasons = reasons;
    return this;
  }

  @Override
  public Action set(String fieldName, Object value) {
    return (Action) super.set(fieldName, value);
  }

  @Override
  public Action clone() {
    return (Action) super.clone();
  }

}
