/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * A single reason why the action is not available.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ActionReason extends com.google.api.client.json.GenericJson {

  /**
   * Optional. An action that needs to be performed to solve the problem represented by this reason.
   * This action will always be available. Should be rendered as a link or button next to the
   * summarizing message. For example, the review may be available only once merchant configure all
   * required attributes. In such a situation this action can be a link to the form, where they can
   * fill the missing attribute to unblock the main action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Action action;

  /**
   * Detailed explanation of the reason. Should be displayed as a hint if present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String detail;

  /**
   * Messages summarizing the reason, why the action is not available. For example: "Review
   * requested on Jan 03. Review requests can take a few days to complete."
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String message;

  /**
   * Optional. An action that needs to be performed to solve the problem represented by this reason.
   * This action will always be available. Should be rendered as a link or button next to the
   * summarizing message. For example, the review may be available only once merchant configure all
   * required attributes. In such a situation this action can be a link to the form, where they can
   * fill the missing attribute to unblock the main action.
   * @return value or {@code null} for none
   */
  public Action getAction() {
    return action;
  }

  /**
   * Optional. An action that needs to be performed to solve the problem represented by this reason.
   * This action will always be available. Should be rendered as a link or button next to the
   * summarizing message. For example, the review may be available only once merchant configure all
   * required attributes. In such a situation this action can be a link to the form, where they can
   * fill the missing attribute to unblock the main action.
   * @param action action or {@code null} for none
   */
  public ActionReason setAction(Action action) {
    this.action = action;
    return this;
  }

  /**
   * Detailed explanation of the reason. Should be displayed as a hint if present.
   * @return value or {@code null} for none
   */
  public java.lang.String getDetail() {
    return detail;
  }

  /**
   * Detailed explanation of the reason. Should be displayed as a hint if present.
   * @param detail detail or {@code null} for none
   */
  public ActionReason setDetail(java.lang.String detail) {
    this.detail = detail;
    return this;
  }

  /**
   * Messages summarizing the reason, why the action is not available. For example: "Review
   * requested on Jan 03. Review requests can take a few days to complete."
   * @return value or {@code null} for none
   */
  public java.lang.String getMessage() {
    return message;
  }

  /**
   * Messages summarizing the reason, why the action is not available. For example: "Review
   * requested on Jan 03. Review requests can take a few days to complete."
   * @param message message or {@code null} for none
   */
  public ActionReason setMessage(java.lang.String message) {
    this.message = message;
    return this;
  }

  @Override
  public ActionReason set(String fieldName, Object value) {
    return (ActionReason) super.set(fieldName, value);
  }

  @Override
  public ActionReason clone() {
    return (ActionReason) super.clone();
  }

}
