/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The Alternate Dispute Resolution (ADR) that may be available to merchants in some regions. If
 * present, the link should be shown on the same page as the list of issues.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AlternateDisputeResolution extends com.google.api.client.json.GenericJson {

  /**
   * The label for the alternate dispute resolution link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * The URL pointing to a page, where merchant can request alternative dispute resolution with an
   * [external body](https://support.google.com/european-union-digital-services-act-redress-
   * options/answer/13535501).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uri;

  /**
   * The label for the alternate dispute resolution link.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * The label for the alternate dispute resolution link.
   * @param label label or {@code null} for none
   */
  public AlternateDisputeResolution setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * The URL pointing to a page, where merchant can request alternative dispute resolution with an
   * [external body](https://support.google.com/european-union-digital-services-act-redress-
   * options/answer/13535501).
   * @return value or {@code null} for none
   */
  public java.lang.String getUri() {
    return uri;
  }

  /**
   * The URL pointing to a page, where merchant can request alternative dispute resolution with an
   * [external body](https://support.google.com/european-union-digital-services-act-redress-
   * options/answer/13535501).
   * @param uri uri or {@code null} for none
   */
  public AlternateDisputeResolution setUri(java.lang.String uri) {
    this.uri = uri;
    return this;
  }

  @Override
  public AlternateDisputeResolution set(String fieldName, Object value) {
    return (AlternateDisputeResolution) super.set(fieldName, value);
  }

  @Override
  public AlternateDisputeResolution clone() {
    return (AlternateDisputeResolution) super.clone();
  }

}
