/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * A detailed impact breakdown for a group of regions where the impact of the issue on different
 * shopping destinations is the same.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Breakdown extends com.google.api.client.json.GenericJson {

  /**
   * Human readable, localized description of issue's effect on different targets. Should be
   * rendered as a list. For example: * "Products not showing in ads" * "Products not showing
   * organically"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> details;

  /**
   * Lists of regions. Should be rendered as a title for this group of details. The full list should
   * be shown to merchant. If the list is too long, it is recommended to make it expandable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<BreakdownRegion> regions;

  /**
   * Human readable, localized description of issue's effect on different targets. Should be
   * rendered as a list. For example: * "Products not showing in ads" * "Products not showing
   * organically"
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDetails() {
    return details;
  }

  /**
   * Human readable, localized description of issue's effect on different targets. Should be
   * rendered as a list. For example: * "Products not showing in ads" * "Products not showing
   * organically"
   * @param details details or {@code null} for none
   */
  public Breakdown setDetails(java.util.List<java.lang.String> details) {
    this.details = details;
    return this;
  }

  /**
   * Lists of regions. Should be rendered as a title for this group of details. The full list should
   * be shown to merchant. If the list is too long, it is recommended to make it expandable.
   * @return value or {@code null} for none
   */
  public java.util.List<BreakdownRegion> getRegions() {
    return regions;
  }

  /**
   * Lists of regions. Should be rendered as a title for this group of details. The full list should
   * be shown to merchant. If the list is too long, it is recommended to make it expandable.
   * @param regions regions or {@code null} for none
   */
  public Breakdown setRegions(java.util.List<BreakdownRegion> regions) {
    this.regions = regions;
    return this;
  }

  @Override
  public Breakdown set(String fieldName, Object value) {
    return (Breakdown) super.set(fieldName, value);
  }

  @Override
  public Breakdown clone() {
    return (Breakdown) super.clone();
  }

}
