/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Action that is implemented and performed in (your) third-party application. Represents various
 * functionality that is expected to be available to merchant and will help them with resolving the
 * issue. The application should point the merchant to the place, where they can access the
 * corresponding functionality. If the functionality is not supported, it is recommended to explain
 * the situation to merchant and provide them with instructions how to solve the issue.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BuiltInSimpleAction extends com.google.api.client.json.GenericJson {

  /**
   * Long text from an external source that should be available to the merchant. Present when the
   * type is `SHOW_ADDITIONAL_CONTENT`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BuiltInSimpleActionAdditionalContent additionalContent;

  /**
   * The attribute that needs to be updated. Present when the type is `EDIT_ITEM_ATTRIBUTE`. This
   * field contains a code for attribute, represented in snake_case. You can find a list of
   * product's attributes, with their codes
   * [here](https://support.google.com/merchants/answer/7052112).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String attributeCode;

  /**
   * The type of action that represents a functionality that is expected to be available in third-
   * party application.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Long text from an external source that should be available to the merchant. Present when the
   * type is `SHOW_ADDITIONAL_CONTENT`.
   * @return value or {@code null} for none
   */
  public BuiltInSimpleActionAdditionalContent getAdditionalContent() {
    return additionalContent;
  }

  /**
   * Long text from an external source that should be available to the merchant. Present when the
   * type is `SHOW_ADDITIONAL_CONTENT`.
   * @param additionalContent additionalContent or {@code null} for none
   */
  public BuiltInSimpleAction setAdditionalContent(BuiltInSimpleActionAdditionalContent additionalContent) {
    this.additionalContent = additionalContent;
    return this;
  }

  /**
   * The attribute that needs to be updated. Present when the type is `EDIT_ITEM_ATTRIBUTE`. This
   * field contains a code for attribute, represented in snake_case. You can find a list of
   * product's attributes, with their codes
   * [here](https://support.google.com/merchants/answer/7052112).
   * @return value or {@code null} for none
   */
  public java.lang.String getAttributeCode() {
    return attributeCode;
  }

  /**
   * The attribute that needs to be updated. Present when the type is `EDIT_ITEM_ATTRIBUTE`. This
   * field contains a code for attribute, represented in snake_case. You can find a list of
   * product's attributes, with their codes
   * [here](https://support.google.com/merchants/answer/7052112).
   * @param attributeCode attributeCode or {@code null} for none
   */
  public BuiltInSimpleAction setAttributeCode(java.lang.String attributeCode) {
    this.attributeCode = attributeCode;
    return this;
  }

  /**
   * The type of action that represents a functionality that is expected to be available in third-
   * party application.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of action that represents a functionality that is expected to be available in third-
   * party application.
   * @param type type or {@code null} for none
   */
  public BuiltInSimpleAction setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public BuiltInSimpleAction set(String fieldName, Object value) {
    return (BuiltInSimpleAction) super.set(fieldName, value);
  }

  @Override
  public BuiltInSimpleAction clone() {
    return (BuiltInSimpleAction) super.clone();
  }

}
