/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for CarrierRate.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CarrierRate extends com.google.api.client.json.GenericJson {

  /**
   * Carrier service, such as `"UPS"` or `"Fedex"`. The list of supported carriers can be retrieved
   * through the `getSupportedCarriers` method. Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String carrierName;

  /**
   * Carrier service, such as `"ground"` or `"2 days"`. The list of supported services for a carrier
   * can be retrieved through the `getSupportedCarriers` method. Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String carrierService;

  /**
   * Additive shipping rate modifier. Can be negative. For example `{ "value": "1", "currency" :
   * "USD" }` adds $1 to the rate, `{ "value": "-3", "currency" : "USD" }` removes $3 from the rate.
   * Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price flatAdjustment;

  /**
   * Name of the carrier rate. Must be unique per rate group. Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Shipping origin for this carrier rate. Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String originPostalCode;

  /**
   * Multiplicative shipping rate modifier as a number in decimal notation. Can be negative. For
   * example `"5.4"` increases the rate by 5.4%, `"-3"` decreases the rate by 3%. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String percentageAdjustment;

  /**
   * Carrier service, such as `"UPS"` or `"Fedex"`. The list of supported carriers can be retrieved
   * through the `getSupportedCarriers` method. Required.
   * @return value or {@code null} for none
   */
  public java.lang.String getCarrierName() {
    return carrierName;
  }

  /**
   * Carrier service, such as `"UPS"` or `"Fedex"`. The list of supported carriers can be retrieved
   * through the `getSupportedCarriers` method. Required.
   * @param carrierName carrierName or {@code null} for none
   */
  public CarrierRate setCarrierName(java.lang.String carrierName) {
    this.carrierName = carrierName;
    return this;
  }

  /**
   * Carrier service, such as `"ground"` or `"2 days"`. The list of supported services for a carrier
   * can be retrieved through the `getSupportedCarriers` method. Required.
   * @return value or {@code null} for none
   */
  public java.lang.String getCarrierService() {
    return carrierService;
  }

  /**
   * Carrier service, such as `"ground"` or `"2 days"`. The list of supported services for a carrier
   * can be retrieved through the `getSupportedCarriers` method. Required.
   * @param carrierService carrierService or {@code null} for none
   */
  public CarrierRate setCarrierService(java.lang.String carrierService) {
    this.carrierService = carrierService;
    return this;
  }

  /**
   * Additive shipping rate modifier. Can be negative. For example `{ "value": "1", "currency" :
   * "USD" }` adds $1 to the rate, `{ "value": "-3", "currency" : "USD" }` removes $3 from the rate.
   * Optional.
   * @return value or {@code null} for none
   */
  public Price getFlatAdjustment() {
    return flatAdjustment;
  }

  /**
   * Additive shipping rate modifier. Can be negative. For example `{ "value": "1", "currency" :
   * "USD" }` adds $1 to the rate, `{ "value": "-3", "currency" : "USD" }` removes $3 from the rate.
   * Optional.
   * @param flatAdjustment flatAdjustment or {@code null} for none
   */
  public CarrierRate setFlatAdjustment(Price flatAdjustment) {
    this.flatAdjustment = flatAdjustment;
    return this;
  }

  /**
   * Name of the carrier rate. Must be unique per rate group. Required.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the carrier rate. Must be unique per rate group. Required.
   * @param name name or {@code null} for none
   */
  public CarrierRate setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Shipping origin for this carrier rate. Required.
   * @return value or {@code null} for none
   */
  public java.lang.String getOriginPostalCode() {
    return originPostalCode;
  }

  /**
   * Shipping origin for this carrier rate. Required.
   * @param originPostalCode originPostalCode or {@code null} for none
   */
  public CarrierRate setOriginPostalCode(java.lang.String originPostalCode) {
    this.originPostalCode = originPostalCode;
    return this;
  }

  /**
   * Multiplicative shipping rate modifier as a number in decimal notation. Can be negative. For
   * example `"5.4"` increases the rate by 5.4%, `"-3"` decreases the rate by 3%. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getPercentageAdjustment() {
    return percentageAdjustment;
  }

  /**
   * Multiplicative shipping rate modifier as a number in decimal notation. Can be negative. For
   * example `"5.4"` increases the rate by 5.4%, `"-3"` decreases the rate by 3%. Optional.
   * @param percentageAdjustment percentageAdjustment or {@code null} for none
   */
  public CarrierRate setPercentageAdjustment(java.lang.String percentageAdjustment) {
    this.percentageAdjustment = percentageAdjustment;
    return this;
  }

  @Override
  public CarrierRate set(String fieldName, Object value) {
    return (CarrierRate) super.set(fieldName, value);
  }

  @Override
  public CarrierRate clone() {
    return (CarrierRate) super.clone();
  }

}
