/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * `CheckoutSettings` for a specific merchant ID.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CheckoutSettings extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The effective value of enrollment state for a given merchant ID. If account level
   * settings are present then this value will be a copy of the account level settings. Otherwise,
   * it will have the value of the parent account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String effectiveEnrollmentState;

  /**
   * Output only. The effective value of review state for a given merchant ID. If account level
   * settings are present then this value will be a copy of the account level settings. Otherwise,
   * it will have the value of the parent account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String effectiveReviewState;

  /**
   * The effective value of `url_settings` for a given merchant ID. If account level settings are
   * present then this value will be a copy of the account level settings. Otherwise, it will have
   * the value of the parent account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UrlSettings effectiveUriSettings;

  /**
   * Output only. Reflects the merchant enrollment state in `Checkout` feature.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String enrollmentState;

  /**
   * Required. The ID of the account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long merchantId;

  /**
   * Output only. Reflects the merchant review state in `Checkout` feature. This is set based on the
   * data quality reviews of the URL provided by the merchant. A merchant with enrollment state as
   * `ENROLLED` can be in the following review states: `IN_REVIEW`, `APPROVED` or `DISAPPROVED`. A
   * merchant must be in an enrollment_state of `ENROLLED` before a review can begin for the
   * merchant.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reviewState;

  /**
   * URL settings for cart or checkout URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UrlSettings uriSettings;

  /**
   * Output only. The effective value of enrollment state for a given merchant ID. If account level
   * settings are present then this value will be a copy of the account level settings. Otherwise,
   * it will have the value of the parent account.
   * @return value or {@code null} for none
   */
  public java.lang.String getEffectiveEnrollmentState() {
    return effectiveEnrollmentState;
  }

  /**
   * Output only. The effective value of enrollment state for a given merchant ID. If account level
   * settings are present then this value will be a copy of the account level settings. Otherwise,
   * it will have the value of the parent account.
   * @param effectiveEnrollmentState effectiveEnrollmentState or {@code null} for none
   */
  public CheckoutSettings setEffectiveEnrollmentState(java.lang.String effectiveEnrollmentState) {
    this.effectiveEnrollmentState = effectiveEnrollmentState;
    return this;
  }

  /**
   * Output only. The effective value of review state for a given merchant ID. If account level
   * settings are present then this value will be a copy of the account level settings. Otherwise,
   * it will have the value of the parent account.
   * @return value or {@code null} for none
   */
  public java.lang.String getEffectiveReviewState() {
    return effectiveReviewState;
  }

  /**
   * Output only. The effective value of review state for a given merchant ID. If account level
   * settings are present then this value will be a copy of the account level settings. Otherwise,
   * it will have the value of the parent account.
   * @param effectiveReviewState effectiveReviewState or {@code null} for none
   */
  public CheckoutSettings setEffectiveReviewState(java.lang.String effectiveReviewState) {
    this.effectiveReviewState = effectiveReviewState;
    return this;
  }

  /**
   * The effective value of `url_settings` for a given merchant ID. If account level settings are
   * present then this value will be a copy of the account level settings. Otherwise, it will have
   * the value of the parent account.
   * @return value or {@code null} for none
   */
  public UrlSettings getEffectiveUriSettings() {
    return effectiveUriSettings;
  }

  /**
   * The effective value of `url_settings` for a given merchant ID. If account level settings are
   * present then this value will be a copy of the account level settings. Otherwise, it will have
   * the value of the parent account.
   * @param effectiveUriSettings effectiveUriSettings or {@code null} for none
   */
  public CheckoutSettings setEffectiveUriSettings(UrlSettings effectiveUriSettings) {
    this.effectiveUriSettings = effectiveUriSettings;
    return this;
  }

  /**
   * Output only. Reflects the merchant enrollment state in `Checkout` feature.
   * @return value or {@code null} for none
   */
  public java.lang.String getEnrollmentState() {
    return enrollmentState;
  }

  /**
   * Output only. Reflects the merchant enrollment state in `Checkout` feature.
   * @param enrollmentState enrollmentState or {@code null} for none
   */
  public CheckoutSettings setEnrollmentState(java.lang.String enrollmentState) {
    this.enrollmentState = enrollmentState;
    return this;
  }

  /**
   * Required. The ID of the account.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMerchantId() {
    return merchantId;
  }

  /**
   * Required. The ID of the account.
   * @param merchantId merchantId or {@code null} for none
   */
  public CheckoutSettings setMerchantId(java.lang.Long merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  /**
   * Output only. Reflects the merchant review state in `Checkout` feature. This is set based on the
   * data quality reviews of the URL provided by the merchant. A merchant with enrollment state as
   * `ENROLLED` can be in the following review states: `IN_REVIEW`, `APPROVED` or `DISAPPROVED`. A
   * merchant must be in an enrollment_state of `ENROLLED` before a review can begin for the
   * merchant.
   * @return value or {@code null} for none
   */
  public java.lang.String getReviewState() {
    return reviewState;
  }

  /**
   * Output only. Reflects the merchant review state in `Checkout` feature. This is set based on the
   * data quality reviews of the URL provided by the merchant. A merchant with enrollment state as
   * `ENROLLED` can be in the following review states: `IN_REVIEW`, `APPROVED` or `DISAPPROVED`. A
   * merchant must be in an enrollment_state of `ENROLLED` before a review can begin for the
   * merchant.
   * @param reviewState reviewState or {@code null} for none
   */
  public CheckoutSettings setReviewState(java.lang.String reviewState) {
    this.reviewState = reviewState;
    return this;
  }

  /**
   * URL settings for cart or checkout URL.
   * @return value or {@code null} for none
   */
  public UrlSettings getUriSettings() {
    return uriSettings;
  }

  /**
   * URL settings for cart or checkout URL.
   * @param uriSettings uriSettings or {@code null} for none
   */
  public CheckoutSettings setUriSettings(UrlSettings uriSettings) {
    this.uriSettings = uriSettings;
    return this;
  }

  @Override
  public CheckoutSettings set(String fieldName, Object value) {
    return (CheckoutSettings) super.set(fieldName, value);
  }

  @Override
  public CheckoutSettings clone() {
    return (CheckoutSettings) super.clone();
  }

}
