/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Destination status message.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CollectionStatusDestinationStatus extends com.google.api.client.json.GenericJson {

  /**
   * Country codes (ISO 3166-1 alpha-2) where the collection is approved.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> approvedCountries;

  /**
   * The name of the destination
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destination;

  /**
   * Country codes (ISO 3166-1 alpha-2) where the collection is disapproved.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> disapprovedCountries;

  /**
   * Country codes (ISO 3166-1 alpha-2) where the collection is pending approval.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> pendingCountries;

  /**
   * The status for the specified destination in the collections target country.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Country codes (ISO 3166-1 alpha-2) where the collection is approved.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getApprovedCountries() {
    return approvedCountries;
  }

  /**
   * Country codes (ISO 3166-1 alpha-2) where the collection is approved.
   * @param approvedCountries approvedCountries or {@code null} for none
   */
  public CollectionStatusDestinationStatus setApprovedCountries(java.util.List<java.lang.String> approvedCountries) {
    this.approvedCountries = approvedCountries;
    return this;
  }

  /**
   * The name of the destination
   * @return value or {@code null} for none
   */
  public java.lang.String getDestination() {
    return destination;
  }

  /**
   * The name of the destination
   * @param destination destination or {@code null} for none
   */
  public CollectionStatusDestinationStatus setDestination(java.lang.String destination) {
    this.destination = destination;
    return this;
  }

  /**
   * Country codes (ISO 3166-1 alpha-2) where the collection is disapproved.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDisapprovedCountries() {
    return disapprovedCountries;
  }

  /**
   * Country codes (ISO 3166-1 alpha-2) where the collection is disapproved.
   * @param disapprovedCountries disapprovedCountries or {@code null} for none
   */
  public CollectionStatusDestinationStatus setDisapprovedCountries(java.util.List<java.lang.String> disapprovedCountries) {
    this.disapprovedCountries = disapprovedCountries;
    return this;
  }

  /**
   * Country codes (ISO 3166-1 alpha-2) where the collection is pending approval.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPendingCountries() {
    return pendingCountries;
  }

  /**
   * Country codes (ISO 3166-1 alpha-2) where the collection is pending approval.
   * @param pendingCountries pendingCountries or {@code null} for none
   */
  public CollectionStatusDestinationStatus setPendingCountries(java.util.List<java.lang.String> pendingCountries) {
    this.pendingCountries = pendingCountries;
    return this;
  }

  /**
   * The status for the specified destination in the collections target country.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The status for the specified destination in the collections target country.
   * @param status status or {@code null} for none
   */
  public CollectionStatusDestinationStatus setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public CollectionStatusDestinationStatus set(String fieldName, Object value) {
    return (CollectionStatusDestinationStatus) super.set(fieldName, value);
  }

  @Override
  public CollectionStatusDestinationStatus clone() {
    return (CollectionStatusDestinationStatus) super.clone();
  }

}
