/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Fields related to [competitive visibility reports]
 * (https://support.google.com/merchants/answer/11366442).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CompetitiveVisibility extends com.google.api.client.json.GenericJson {

  /**
   * [Ads / organic ratio] (https://support.google.com/merchants/answer/11366442#zippy=%2Cadsfree-
   * ratio) shows how often a merchant receives impressions from Shopping ads compared to organic
   * traffic. The number is rounded and bucketed. Available only in
   * `CompetitiveVisibilityTopMerchantView` and `CompetitiveVisibilityCompetitorView`. Cannot be
   * filtered on in the 'WHERE' clause.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double adsOrganicRatio;

  /**
   * Change in visibility based on impressions with respect to the start of the selected time range
   * (or first day with non-zero impressions) for a combined set of merchants with highest
   * visibility approximating the market. Available only in `CompetitiveVisibilityBenchmarkView`.
   * Cannot be filtered on in the 'WHERE' clause.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double categoryBenchmarkVisibilityTrend;

  /**
   * Google product category ID to calculate the report for, represented in [Google's product
   * taxonomy](https://support.google.com/merchants/answer/6324436). Required in the `SELECT`
   * clause. A `WHERE` condition on `competitive_visibility.category_id` is required in the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long categoryId;

  /**
   * The country where impression appeared. Required in the `SELECT` clause. A `WHERE` condition on
   * `competitive_visibility.country_code` is required in the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String countryCode;

  /**
   * Date of this row. Available only in `CompetitiveVisibilityBenchmarkView` and
   * `CompetitiveVisibilityCompetitorView`. Required in the `SELECT` clause for
   * `CompetitiveVisibilityMarketBenchmarkView`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Date date;

  /**
   * Domain of your competitor or your domain, if 'is_your_domain' is true. Available only in
   * `CompetitiveVisibilityTopMerchantView` and `CompetitiveVisibilityCompetitorView`. Required in
   * the `SELECT` clause for `CompetitiveVisibilityTopMerchantView` and
   * `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE' clause.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String domain;

  /**
   * Higher position rate shows how often a competitor’s offer got placed in a higher position on
   * the page than your offer. Available only in `CompetitiveVisibilityTopMerchantView` and
   * `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE' clause.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double higherPositionRate;

  /**
   * True if this row contains data for your domain. Available only in
   * `CompetitiveVisibilityTopMerchantView` and `CompetitiveVisibilityCompetitorView`. Cannot be
   * filtered on in the 'WHERE' clause.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isYourDomain;

  /**
   * Page overlap rate describes how frequently competing retailers’ offers are shown together with
   * your offers on the same page. Available only in `CompetitiveVisibilityTopMerchantView` and
   * `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE' clause.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double pageOverlapRate;

  /**
   * Position of the domain in the top merchants ranking for the selected keys (`date`,
   * `category_id`, `country_code`, `listing_type`) based on impressions. 1 is the highest.
   * Available only in `CompetitiveVisibilityTopMerchantView` and
   * `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE' clause.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger rank;

  /**
   * Relative visibility shows how often your competitors’ offers are shown compared to your offers.
   * In other words, this is the number of displayed impressions of a competitor retailer divided by
   * the number of your displayed impressions during a selected time range for a selected product
   * category and country. Available only in `CompetitiveVisibilityCompetitorView`. Cannot be
   * filtered on in the 'WHERE' clause.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double relativeVisibility;

  /**
   * Type of impression listing. Required in the `SELECT` clause. Cannot be filtered on in the
   * 'WHERE' clause.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String trafficSource;

  /**
   * Change in visibility based on impressions for your domain with respect to the start of the
   * selected time range (or first day with non-zero impressions). Available only in
   * `CompetitiveVisibilityBenchmarkView`. Cannot be filtered on in the 'WHERE' clause.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double yourDomainVisibilityTrend;

  /**
   * [Ads / organic ratio] (https://support.google.com/merchants/answer/11366442#zippy=%2Cadsfree-
   * ratio) shows how often a merchant receives impressions from Shopping ads compared to organic
   * traffic. The number is rounded and bucketed. Available only in
   * `CompetitiveVisibilityTopMerchantView` and `CompetitiveVisibilityCompetitorView`. Cannot be
   * filtered on in the 'WHERE' clause.
   * @return value or {@code null} for none
   */
  public java.lang.Double getAdsOrganicRatio() {
    return adsOrganicRatio;
  }

  /**
   * [Ads / organic ratio] (https://support.google.com/merchants/answer/11366442#zippy=%2Cadsfree-
   * ratio) shows how often a merchant receives impressions from Shopping ads compared to organic
   * traffic. The number is rounded and bucketed. Available only in
   * `CompetitiveVisibilityTopMerchantView` and `CompetitiveVisibilityCompetitorView`. Cannot be
   * filtered on in the 'WHERE' clause.
   * @param adsOrganicRatio adsOrganicRatio or {@code null} for none
   */
  public CompetitiveVisibility setAdsOrganicRatio(java.lang.Double adsOrganicRatio) {
    this.adsOrganicRatio = adsOrganicRatio;
    return this;
  }

  /**
   * Change in visibility based on impressions with respect to the start of the selected time range
   * (or first day with non-zero impressions) for a combined set of merchants with highest
   * visibility approximating the market. Available only in `CompetitiveVisibilityBenchmarkView`.
   * Cannot be filtered on in the 'WHERE' clause.
   * @return value or {@code null} for none
   */
  public java.lang.Double getCategoryBenchmarkVisibilityTrend() {
    return categoryBenchmarkVisibilityTrend;
  }

  /**
   * Change in visibility based on impressions with respect to the start of the selected time range
   * (or first day with non-zero impressions) for a combined set of merchants with highest
   * visibility approximating the market. Available only in `CompetitiveVisibilityBenchmarkView`.
   * Cannot be filtered on in the 'WHERE' clause.
   * @param categoryBenchmarkVisibilityTrend categoryBenchmarkVisibilityTrend or {@code null} for none
   */
  public CompetitiveVisibility setCategoryBenchmarkVisibilityTrend(java.lang.Double categoryBenchmarkVisibilityTrend) {
    this.categoryBenchmarkVisibilityTrend = categoryBenchmarkVisibilityTrend;
    return this;
  }

  /**
   * Google product category ID to calculate the report for, represented in [Google's product
   * taxonomy](https://support.google.com/merchants/answer/6324436). Required in the `SELECT`
   * clause. A `WHERE` condition on `competitive_visibility.category_id` is required in the query.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCategoryId() {
    return categoryId;
  }

  /**
   * Google product category ID to calculate the report for, represented in [Google's product
   * taxonomy](https://support.google.com/merchants/answer/6324436). Required in the `SELECT`
   * clause. A `WHERE` condition on `competitive_visibility.category_id` is required in the query.
   * @param categoryId categoryId or {@code null} for none
   */
  public CompetitiveVisibility setCategoryId(java.lang.Long categoryId) {
    this.categoryId = categoryId;
    return this;
  }

  /**
   * The country where impression appeared. Required in the `SELECT` clause. A `WHERE` condition on
   * `competitive_visibility.country_code` is required in the query.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountryCode() {
    return countryCode;
  }

  /**
   * The country where impression appeared. Required in the `SELECT` clause. A `WHERE` condition on
   * `competitive_visibility.country_code` is required in the query.
   * @param countryCode countryCode or {@code null} for none
   */
  public CompetitiveVisibility setCountryCode(java.lang.String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * Date of this row. Available only in `CompetitiveVisibilityBenchmarkView` and
   * `CompetitiveVisibilityCompetitorView`. Required in the `SELECT` clause for
   * `CompetitiveVisibilityMarketBenchmarkView`.
   * @return value or {@code null} for none
   */
  public Date getDate() {
    return date;
  }

  /**
   * Date of this row. Available only in `CompetitiveVisibilityBenchmarkView` and
   * `CompetitiveVisibilityCompetitorView`. Required in the `SELECT` clause for
   * `CompetitiveVisibilityMarketBenchmarkView`.
   * @param date date or {@code null} for none
   */
  public CompetitiveVisibility setDate(Date date) {
    this.date = date;
    return this;
  }

  /**
   * Domain of your competitor or your domain, if 'is_your_domain' is true. Available only in
   * `CompetitiveVisibilityTopMerchantView` and `CompetitiveVisibilityCompetitorView`. Required in
   * the `SELECT` clause for `CompetitiveVisibilityTopMerchantView` and
   * `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE' clause.
   * @return value or {@code null} for none
   */
  public java.lang.String getDomain() {
    return domain;
  }

  /**
   * Domain of your competitor or your domain, if 'is_your_domain' is true. Available only in
   * `CompetitiveVisibilityTopMerchantView` and `CompetitiveVisibilityCompetitorView`. Required in
   * the `SELECT` clause for `CompetitiveVisibilityTopMerchantView` and
   * `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE' clause.
   * @param domain domain or {@code null} for none
   */
  public CompetitiveVisibility setDomain(java.lang.String domain) {
    this.domain = domain;
    return this;
  }

  /**
   * Higher position rate shows how often a competitor’s offer got placed in a higher position on
   * the page than your offer. Available only in `CompetitiveVisibilityTopMerchantView` and
   * `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE' clause.
   * @return value or {@code null} for none
   */
  public java.lang.Double getHigherPositionRate() {
    return higherPositionRate;
  }

  /**
   * Higher position rate shows how often a competitor’s offer got placed in a higher position on
   * the page than your offer. Available only in `CompetitiveVisibilityTopMerchantView` and
   * `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE' clause.
   * @param higherPositionRate higherPositionRate or {@code null} for none
   */
  public CompetitiveVisibility setHigherPositionRate(java.lang.Double higherPositionRate) {
    this.higherPositionRate = higherPositionRate;
    return this;
  }

  /**
   * True if this row contains data for your domain. Available only in
   * `CompetitiveVisibilityTopMerchantView` and `CompetitiveVisibilityCompetitorView`. Cannot be
   * filtered on in the 'WHERE' clause.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsYourDomain() {
    return isYourDomain;
  }

  /**
   * True if this row contains data for your domain. Available only in
   * `CompetitiveVisibilityTopMerchantView` and `CompetitiveVisibilityCompetitorView`. Cannot be
   * filtered on in the 'WHERE' clause.
   * @param isYourDomain isYourDomain or {@code null} for none
   */
  public CompetitiveVisibility setIsYourDomain(java.lang.Boolean isYourDomain) {
    this.isYourDomain = isYourDomain;
    return this;
  }

  /**
   * Page overlap rate describes how frequently competing retailers’ offers are shown together with
   * your offers on the same page. Available only in `CompetitiveVisibilityTopMerchantView` and
   * `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE' clause.
   * @return value or {@code null} for none
   */
  public java.lang.Double getPageOverlapRate() {
    return pageOverlapRate;
  }

  /**
   * Page overlap rate describes how frequently competing retailers’ offers are shown together with
   * your offers on the same page. Available only in `CompetitiveVisibilityTopMerchantView` and
   * `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE' clause.
   * @param pageOverlapRate pageOverlapRate or {@code null} for none
   */
  public CompetitiveVisibility setPageOverlapRate(java.lang.Double pageOverlapRate) {
    this.pageOverlapRate = pageOverlapRate;
    return this;
  }

  /**
   * Position of the domain in the top merchants ranking for the selected keys (`date`,
   * `category_id`, `country_code`, `listing_type`) based on impressions. 1 is the highest.
   * Available only in `CompetitiveVisibilityTopMerchantView` and
   * `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE' clause.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getRank() {
    return rank;
  }

  /**
   * Position of the domain in the top merchants ranking for the selected keys (`date`,
   * `category_id`, `country_code`, `listing_type`) based on impressions. 1 is the highest.
   * Available only in `CompetitiveVisibilityTopMerchantView` and
   * `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the 'WHERE' clause.
   * @param rank rank or {@code null} for none
   */
  public CompetitiveVisibility setRank(java.math.BigInteger rank) {
    this.rank = rank;
    return this;
  }

  /**
   * Relative visibility shows how often your competitors’ offers are shown compared to your offers.
   * In other words, this is the number of displayed impressions of a competitor retailer divided by
   * the number of your displayed impressions during a selected time range for a selected product
   * category and country. Available only in `CompetitiveVisibilityCompetitorView`. Cannot be
   * filtered on in the 'WHERE' clause.
   * @return value or {@code null} for none
   */
  public java.lang.Double getRelativeVisibility() {
    return relativeVisibility;
  }

  /**
   * Relative visibility shows how often your competitors’ offers are shown compared to your offers.
   * In other words, this is the number of displayed impressions of a competitor retailer divided by
   * the number of your displayed impressions during a selected time range for a selected product
   * category and country. Available only in `CompetitiveVisibilityCompetitorView`. Cannot be
   * filtered on in the 'WHERE' clause.
   * @param relativeVisibility relativeVisibility or {@code null} for none
   */
  public CompetitiveVisibility setRelativeVisibility(java.lang.Double relativeVisibility) {
    this.relativeVisibility = relativeVisibility;
    return this;
  }

  /**
   * Type of impression listing. Required in the `SELECT` clause. Cannot be filtered on in the
   * 'WHERE' clause.
   * @return value or {@code null} for none
   */
  public java.lang.String getTrafficSource() {
    return trafficSource;
  }

  /**
   * Type of impression listing. Required in the `SELECT` clause. Cannot be filtered on in the
   * 'WHERE' clause.
   * @param trafficSource trafficSource or {@code null} for none
   */
  public CompetitiveVisibility setTrafficSource(java.lang.String trafficSource) {
    this.trafficSource = trafficSource;
    return this;
  }

  /**
   * Change in visibility based on impressions for your domain with respect to the start of the
   * selected time range (or first day with non-zero impressions). Available only in
   * `CompetitiveVisibilityBenchmarkView`. Cannot be filtered on in the 'WHERE' clause.
   * @return value or {@code null} for none
   */
  public java.lang.Double getYourDomainVisibilityTrend() {
    return yourDomainVisibilityTrend;
  }

  /**
   * Change in visibility based on impressions for your domain with respect to the start of the
   * selected time range (or first day with non-zero impressions). Available only in
   * `CompetitiveVisibilityBenchmarkView`. Cannot be filtered on in the 'WHERE' clause.
   * @param yourDomainVisibilityTrend yourDomainVisibilityTrend or {@code null} for none
   */
  public CompetitiveVisibility setYourDomainVisibilityTrend(java.lang.Double yourDomainVisibilityTrend) {
    this.yourDomainVisibilityTrend = yourDomainVisibilityTrend;
    return this;
  }

  @Override
  public CompetitiveVisibility set(String fieldName, Object value) {
    return (CompetitiveVisibility) super.set(fieldName, value);
  }

  @Override
  public CompetitiveVisibility clone() {
    return (CompetitiveVisibility) super.clone();
  }

}
