/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Represents a conversion source owned by a Merchant account. A merchant account can have up to 200
 * conversion sources.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConversionSource extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Generated by the Content API upon creation of a new `ConversionSource`. Format:
   * [a-z]{4}:.+ The four characters before the colon represent the type of conversio source.
   * Content after the colon represents the ID of the conversion source within that type. The ID of
   * two different conversion sources might be the same across different types. The following type
   * prefixes are supported: - galk: For GoogleAnalyticsLink sources. - mcdn: For
   * MerchantCenterDestination sources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String conversionSourceId;

  /**
   * Output only. The time when an archived conversion source becomes permanently deleted and is no
   * longer available to undelete.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expireTime;

  /**
   * Immutable. Conversion Source of type "Link to Google Analytics Property".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAnalyticsLink googleAnalyticsLink;

  /**
   * Conversion Source of type "Merchant Center Tag Destination".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MerchantCenterDestination merchantCenterDestination;

  /**
   * Output only. Current state of this conversion source. Can't be edited through the API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Output only. Generated by the Content API upon creation of a new `ConversionSource`. Format:
   * [a-z]{4}:.+ The four characters before the colon represent the type of conversio source.
   * Content after the colon represents the ID of the conversion source within that type. The ID of
   * two different conversion sources might be the same across different types. The following type
   * prefixes are supported: - galk: For GoogleAnalyticsLink sources. - mcdn: For
   * MerchantCenterDestination sources.
   * @return value or {@code null} for none
   */
  public java.lang.String getConversionSourceId() {
    return conversionSourceId;
  }

  /**
   * Output only. Generated by the Content API upon creation of a new `ConversionSource`. Format:
   * [a-z]{4}:.+ The four characters before the colon represent the type of conversio source.
   * Content after the colon represents the ID of the conversion source within that type. The ID of
   * two different conversion sources might be the same across different types. The following type
   * prefixes are supported: - galk: For GoogleAnalyticsLink sources. - mcdn: For
   * MerchantCenterDestination sources.
   * @param conversionSourceId conversionSourceId or {@code null} for none
   */
  public ConversionSource setConversionSourceId(java.lang.String conversionSourceId) {
    this.conversionSourceId = conversionSourceId;
    return this;
  }

  /**
   * Output only. The time when an archived conversion source becomes permanently deleted and is no
   * longer available to undelete.
   * @return value or {@code null} for none
   */
  public String getExpireTime() {
    return expireTime;
  }

  /**
   * Output only. The time when an archived conversion source becomes permanently deleted and is no
   * longer available to undelete.
   * @param expireTime expireTime or {@code null} for none
   */
  public ConversionSource setExpireTime(String expireTime) {
    this.expireTime = expireTime;
    return this;
  }

  /**
   * Immutable. Conversion Source of type "Link to Google Analytics Property".
   * @return value or {@code null} for none
   */
  public GoogleAnalyticsLink getGoogleAnalyticsLink() {
    return googleAnalyticsLink;
  }

  /**
   * Immutable. Conversion Source of type "Link to Google Analytics Property".
   * @param googleAnalyticsLink googleAnalyticsLink or {@code null} for none
   */
  public ConversionSource setGoogleAnalyticsLink(GoogleAnalyticsLink googleAnalyticsLink) {
    this.googleAnalyticsLink = googleAnalyticsLink;
    return this;
  }

  /**
   * Conversion Source of type "Merchant Center Tag Destination".
   * @return value or {@code null} for none
   */
  public MerchantCenterDestination getMerchantCenterDestination() {
    return merchantCenterDestination;
  }

  /**
   * Conversion Source of type "Merchant Center Tag Destination".
   * @param merchantCenterDestination merchantCenterDestination or {@code null} for none
   */
  public ConversionSource setMerchantCenterDestination(MerchantCenterDestination merchantCenterDestination) {
    this.merchantCenterDestination = merchantCenterDestination;
    return this;
  }

  /**
   * Output only. Current state of this conversion source. Can't be edited through the API.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. Current state of this conversion source. Can't be edited through the API.
   * @param state state or {@code null} for none
   */
  public ConversionSource setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public ConversionSource set(String fieldName, Object value) {
    return (ConversionSource) super.set(fieldName, value);
  }

  @Override
  public ConversionSource clone() {
    return (ConversionSource) super.clone();
  }

}
