/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for CustomerReturnReason.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CustomerReturnReason extends com.google.api.client.json.GenericJson {

  /**
   * Description of the reason.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Code of the return reason. Acceptable values are: - "`betterPriceFound`" - "`changedMind`" -
   * "`damagedOrDefectiveItem`" - "`didNotMatchDescription`" - "`doesNotFit`" - "`expiredItem`" -
   * "`incorrectItemReceived`" - "`noLongerNeeded`" - "`notSpecified`" - "`orderedWrongItem`" -
   * "`other`" - "`qualityNotExpected`" - "`receivedTooLate`" - "`undeliverable`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reasonCode;

  /**
   * Description of the reason.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Description of the reason.
   * @param description description or {@code null} for none
   */
  public CustomerReturnReason setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Code of the return reason. Acceptable values are: - "`betterPriceFound`" - "`changedMind`" -
   * "`damagedOrDefectiveItem`" - "`didNotMatchDescription`" - "`doesNotFit`" - "`expiredItem`" -
   * "`incorrectItemReceived`" - "`noLongerNeeded`" - "`notSpecified`" - "`orderedWrongItem`" -
   * "`other`" - "`qualityNotExpected`" - "`receivedTooLate`" - "`undeliverable`"
   * @return value or {@code null} for none
   */
  public java.lang.String getReasonCode() {
    return reasonCode;
  }

  /**
   * Code of the return reason. Acceptable values are: - "`betterPriceFound`" - "`changedMind`" -
   * "`damagedOrDefectiveItem`" - "`didNotMatchDescription`" - "`doesNotFit`" - "`expiredItem`" -
   * "`incorrectItemReceived`" - "`noLongerNeeded`" - "`notSpecified`" - "`orderedWrongItem`" -
   * "`other`" - "`qualityNotExpected`" - "`receivedTooLate`" - "`undeliverable`"
   * @param reasonCode reasonCode or {@code null} for none
   */
  public CustomerReturnReason setReasonCode(java.lang.String reasonCode) {
    this.reasonCode = reasonCode;
    return this;
  }

  @Override
  public CustomerReturnReason set(String fieldName, Object value) {
    return (CustomerReturnReason) super.set(fieldName, value);
  }

  @Override
  public CustomerReturnReason clone() {
    return (CustomerReturnReason) super.clone();
  }

}
