/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Datafeed configuration data.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Datafeed extends com.google.api.client.json.GenericJson {

  /**
   * The two-letter ISO 639-1 language in which the attributes are defined in the data feed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String attributeLanguage;

  /**
   * Required. The type of data feed. For product inventory feeds, only feeds for local stores, not
   * online stores, are supported. Acceptable values are: - "`local products`" - "`product
   * inventory`" - "`products`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentType;

  /**
   * Fetch schedule for the feed file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DatafeedFetchSchedule fetchSchedule;

  /**
   * Required. The filename of the feed. All feeds must have a unique file name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileName;

  /**
   * Format of the feed file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DatafeedFormat format;

  /**
   * Required for update. The ID of the data feed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#datafeed`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Required for insert. A descriptive name of the data feed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The targets this feed should apply to (country, language, destinations).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DatafeedTarget> targets;

  /**
   * The two-letter ISO 639-1 language in which the attributes are defined in the data feed.
   * @return value or {@code null} for none
   */
  public java.lang.String getAttributeLanguage() {
    return attributeLanguage;
  }

  /**
   * The two-letter ISO 639-1 language in which the attributes are defined in the data feed.
   * @param attributeLanguage attributeLanguage or {@code null} for none
   */
  public Datafeed setAttributeLanguage(java.lang.String attributeLanguage) {
    this.attributeLanguage = attributeLanguage;
    return this;
  }

  /**
   * Required. The type of data feed. For product inventory feeds, only feeds for local stores, not
   * online stores, are supported. Acceptable values are: - "`local products`" - "`product
   * inventory`" - "`products`"
   * @return value or {@code null} for none
   */
  public java.lang.String getContentType() {
    return contentType;
  }

  /**
   * Required. The type of data feed. For product inventory feeds, only feeds for local stores, not
   * online stores, are supported. Acceptable values are: - "`local products`" - "`product
   * inventory`" - "`products`"
   * @param contentType contentType or {@code null} for none
   */
  public Datafeed setContentType(java.lang.String contentType) {
    this.contentType = contentType;
    return this;
  }

  /**
   * Fetch schedule for the feed file.
   * @return value or {@code null} for none
   */
  public DatafeedFetchSchedule getFetchSchedule() {
    return fetchSchedule;
  }

  /**
   * Fetch schedule for the feed file.
   * @param fetchSchedule fetchSchedule or {@code null} for none
   */
  public Datafeed setFetchSchedule(DatafeedFetchSchedule fetchSchedule) {
    this.fetchSchedule = fetchSchedule;
    return this;
  }

  /**
   * Required. The filename of the feed. All feeds must have a unique file name.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileName() {
    return fileName;
  }

  /**
   * Required. The filename of the feed. All feeds must have a unique file name.
   * @param fileName fileName or {@code null} for none
   */
  public Datafeed setFileName(java.lang.String fileName) {
    this.fileName = fileName;
    return this;
  }

  /**
   * Format of the feed file.
   * @return value or {@code null} for none
   */
  public DatafeedFormat getFormat() {
    return format;
  }

  /**
   * Format of the feed file.
   * @param format format or {@code null} for none
   */
  public Datafeed setFormat(DatafeedFormat format) {
    this.format = format;
    return this;
  }

  /**
   * Required for update. The ID of the data feed.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * Required for update. The ID of the data feed.
   * @param id id or {@code null} for none
   */
  public Datafeed setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#datafeed`"
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#datafeed`"
   * @param kind kind or {@code null} for none
   */
  public Datafeed setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Required for insert. A descriptive name of the data feed.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required for insert. A descriptive name of the data feed.
   * @param name name or {@code null} for none
   */
  public Datafeed setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The targets this feed should apply to (country, language, destinations).
   * @return value or {@code null} for none
   */
  public java.util.List<DatafeedTarget> getTargets() {
    return targets;
  }

  /**
   * The targets this feed should apply to (country, language, destinations).
   * @param targets targets or {@code null} for none
   */
  public Datafeed setTargets(java.util.List<DatafeedTarget> targets) {
    this.targets = targets;
    return this;
  }

  @Override
  public Datafeed set(String fieldName, Object value) {
    return (Datafeed) super.set(fieldName, value);
  }

  @Override
  public Datafeed clone() {
    return (Datafeed) super.clone();
  }

}
