/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * An error occurring in the feed, like "invalid price".
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DatafeedStatusError extends com.google.api.client.json.GenericJson {

  /**
   * The code of the error, for example, "validation/invalid_value".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String code;

  /**
   * The number of occurrences of the error in the feed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger count;

  /**
   * A list of example occurrences of the error, grouped by product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DatafeedStatusExample> examples;

  /**
   * The error message, for example, "Invalid price".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String message;

  /**
   * The code of the error, for example, "validation/invalid_value".
   * @return value or {@code null} for none
   */
  public java.lang.String getCode() {
    return code;
  }

  /**
   * The code of the error, for example, "validation/invalid_value".
   * @param code code or {@code null} for none
   */
  public DatafeedStatusError setCode(java.lang.String code) {
    this.code = code;
    return this;
  }

  /**
   * The number of occurrences of the error in the feed.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getCount() {
    return count;
  }

  /**
   * The number of occurrences of the error in the feed.
   * @param count count or {@code null} for none
   */
  public DatafeedStatusError setCount(java.math.BigInteger count) {
    this.count = count;
    return this;
  }

  /**
   * A list of example occurrences of the error, grouped by product.
   * @return value or {@code null} for none
   */
  public java.util.List<DatafeedStatusExample> getExamples() {
    return examples;
  }

  /**
   * A list of example occurrences of the error, grouped by product.
   * @param examples examples or {@code null} for none
   */
  public DatafeedStatusError setExamples(java.util.List<DatafeedStatusExample> examples) {
    this.examples = examples;
    return this;
  }

  /**
   * The error message, for example, "Invalid price".
   * @return value or {@code null} for none
   */
  public java.lang.String getMessage() {
    return message;
  }

  /**
   * The error message, for example, "Invalid price".
   * @param message message or {@code null} for none
   */
  public DatafeedStatusError setMessage(java.lang.String message) {
    this.message = message;
    return this;
  }

  @Override
  public DatafeedStatusError set(String fieldName, Object value) {
    return (DatafeedStatusError) super.set(fieldName, value);
  }

  @Override
  public DatafeedStatusError clone() {
    return (DatafeedStatusError) super.clone();
  }

}
