/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Represents civil time (or occasionally physical time). This type can represent a civil time in
 * one of a few possible ways: * When utc_offset is set and time_zone is unset: a civil time on a
 * calendar day with a particular offset from UTC. * When time_zone is set and utc_offset is unset:
 * a civil time on a calendar day in a particular time zone. * When neither time_zone nor utc_offset
 * is set: a civil time on a calendar day in local time. The date is relative to the Proleptic
 * Gregorian Calendar. If year, month, or day are 0, the DateTime is considered not to have a
 * specific year, month, or day respectively. This type may also be used to represent a physical
 * time if all the date and time fields are set and either case of the `time_offset` oneof is set.
 * Consider using `Timestamp` message for physical time instead. If your use case also would like to
 * store the user's timezone, that can be done in another field. This type is more flexible than
 * some applications may want. Make sure to document and validate your application's limitations.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DateTime extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if
   * specifying a datetime without a day.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer day;

  /**
   * Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0 (midnight). An
   * API may choose to allow the value "24:00:00" for scenarios like business closing time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer hours;

  /**
   * Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minutes;

  /**
   * Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a month.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer month;

  /**
   * Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults to 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer nanos;

  /**
   * Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0. An API
   * may allow the value 60 if it allows leap-seconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer seconds;

  /**
   * Time zone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeZone timeZone;

  /**
   * UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC offset
   * of -4:00 would be represented as { seconds: -14400 }.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String utcOffset;

  /**
   * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a year.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer year;

  /**
   * Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if
   * specifying a datetime without a day.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getDay() {
    return day;
  }

  /**
   * Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if
   * specifying a datetime without a day.
   * @param day day or {@code null} for none
   */
  public DateTime setDay(java.lang.Integer day) {
    this.day = day;
    return this;
  }

  /**
   * Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0 (midnight). An
   * API may choose to allow the value "24:00:00" for scenarios like business closing time.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHours() {
    return hours;
  }

  /**
   * Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0 (midnight). An
   * API may choose to allow the value "24:00:00" for scenarios like business closing time.
   * @param hours hours or {@code null} for none
   */
  public DateTime setHours(java.lang.Integer hours) {
    this.hours = hours;
    return this;
  }

  /**
   * Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinutes() {
    return minutes;
  }

  /**
   * Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0.
   * @param minutes minutes or {@code null} for none
   */
  public DateTime setMinutes(java.lang.Integer minutes) {
    this.minutes = minutes;
    return this;
  }

  /**
   * Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a month.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMonth() {
    return month;
  }

  /**
   * Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a month.
   * @param month month or {@code null} for none
   */
  public DateTime setMonth(java.lang.Integer month) {
    this.month = month;
    return this;
  }

  /**
   * Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults to 0.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNanos() {
    return nanos;
  }

  /**
   * Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults to 0.
   * @param nanos nanos or {@code null} for none
   */
  public DateTime setNanos(java.lang.Integer nanos) {
    this.nanos = nanos;
    return this;
  }

  /**
   * Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0. An API
   * may allow the value 60 if it allows leap-seconds.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSeconds() {
    return seconds;
  }

  /**
   * Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0. An API
   * may allow the value 60 if it allows leap-seconds.
   * @param seconds seconds or {@code null} for none
   */
  public DateTime setSeconds(java.lang.Integer seconds) {
    this.seconds = seconds;
    return this;
  }

  /**
   * Time zone.
   * @return value or {@code null} for none
   */
  public TimeZone getTimeZone() {
    return timeZone;
  }

  /**
   * Time zone.
   * @param timeZone timeZone or {@code null} for none
   */
  public DateTime setTimeZone(TimeZone timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  /**
   * UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC offset
   * of -4:00 would be represented as { seconds: -14400 }.
   * @return value or {@code null} for none
   */
  public String getUtcOffset() {
    return utcOffset;
  }

  /**
   * UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC offset
   * of -4:00 would be represented as { seconds: -14400 }.
   * @param utcOffset utcOffset or {@code null} for none
   */
  public DateTime setUtcOffset(String utcOffset) {
    this.utcOffset = utcOffset;
    return this;
  }

  /**
   * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a year.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getYear() {
    return year;
  }

  /**
   * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a year.
   * @param year year or {@code null} for none
   */
  public DateTime setYear(java.lang.Integer year) {
    this.year = year;
    return this;
  }

  @Override
  public DateTime set(String fieldName, Object value) {
    return (DateTime) super.set(fieldName, value);
  }

  @Override
  public DateTime clone() {
    return (DateTime) super.clone();
  }

}
