/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * A delivery area for the product. Only one of `countryCode` or `postalCodeRange` must be set.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeliveryArea extends com.google.api.client.json.GenericJson {

  /**
   * Required. The country that the product can be delivered to. Submit a [unicode CLDR
   * region](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) such as `US` or `CH`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String countryCode;

  /**
   * A postal code, postal code range or postal code prefix that defines this area. Limited to US
   * and AUS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeliveryAreaPostalCodeRange postalCodeRange;

  /**
   * A state, territory, or prefecture. This is supported for the United States, Australia, and
   * Japan. Provide a subdivision code from the ISO 3166-2 code tables
   * ([US](https://en.wikipedia.org/wiki/ISO_3166-2:US),
   * [AU](https://en.wikipedia.org/wiki/ISO_3166-2:AU), or
   * [JP](https://en.wikipedia.org/wiki/ISO_3166-2:JP)) without country prefix (for example, `"NY"`,
   * `"NSW"`, `"03"`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String regionCode;

  /**
   * Required. The country that the product can be delivered to. Submit a [unicode CLDR
   * region](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) such as `US` or `CH`.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountryCode() {
    return countryCode;
  }

  /**
   * Required. The country that the product can be delivered to. Submit a [unicode CLDR
   * region](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) such as `US` or `CH`.
   * @param countryCode countryCode or {@code null} for none
   */
  public DeliveryArea setCountryCode(java.lang.String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * A postal code, postal code range or postal code prefix that defines this area. Limited to US
   * and AUS.
   * @return value or {@code null} for none
   */
  public DeliveryAreaPostalCodeRange getPostalCodeRange() {
    return postalCodeRange;
  }

  /**
   * A postal code, postal code range or postal code prefix that defines this area. Limited to US
   * and AUS.
   * @param postalCodeRange postalCodeRange or {@code null} for none
   */
  public DeliveryArea setPostalCodeRange(DeliveryAreaPostalCodeRange postalCodeRange) {
    this.postalCodeRange = postalCodeRange;
    return this;
  }

  /**
   * A state, territory, or prefecture. This is supported for the United States, Australia, and
   * Japan. Provide a subdivision code from the ISO 3166-2 code tables
   * ([US](https://en.wikipedia.org/wiki/ISO_3166-2:US),
   * [AU](https://en.wikipedia.org/wiki/ISO_3166-2:AU), or
   * [JP](https://en.wikipedia.org/wiki/ISO_3166-2:JP)) without country prefix (for example, `"NY"`,
   * `"NSW"`, `"03"`).
   * @return value or {@code null} for none
   */
  public java.lang.String getRegionCode() {
    return regionCode;
  }

  /**
   * A state, territory, or prefecture. This is supported for the United States, Australia, and
   * Japan. Provide a subdivision code from the ISO 3166-2 code tables
   * ([US](https://en.wikipedia.org/wiki/ISO_3166-2:US),
   * [AU](https://en.wikipedia.org/wiki/ISO_3166-2:AU), or
   * [JP](https://en.wikipedia.org/wiki/ISO_3166-2:JP)) without country prefix (for example, `"NY"`,
   * `"NSW"`, `"03"`).
   * @param regionCode regionCode or {@code null} for none
   */
  public DeliveryArea setRegionCode(java.lang.String regionCode) {
    this.regionCode = regionCode;
    return this;
  }

  @Override
  public DeliveryArea set(String fieldName, Object value) {
    return (DeliveryArea) super.set(fieldName, value);
  }

  @Override
  public DeliveryArea clone() {
    return (DeliveryArea) super.clone();
  }

}
