/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * A list of errors returned by a failed batch entry.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Errors extends com.google.api.client.json.GenericJson {

  /**
   * The HTTP status of the first error in `errors`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long code;

  /**
   * A list of errors.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Error> errors;

  static {
    // hack to force ProGuard to consider Error used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Error.class);
  }

  /**
   * The message of the first error in `errors`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String message;

  /**
   * The HTTP status of the first error in `errors`.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCode() {
    return code;
  }

  /**
   * The HTTP status of the first error in `errors`.
   * @param code code or {@code null} for none
   */
  public Errors setCode(java.lang.Long code) {
    this.code = code;
    return this;
  }

  /**
   * A list of errors.
   * @return value or {@code null} for none
   */
  public java.util.List<Error> getErrors() {
    return errors;
  }

  /**
   * A list of errors.
   * @param errors errors or {@code null} for none
   */
  public Errors setErrors(java.util.List<Error> errors) {
    this.errors = errors;
    return this;
  }

  /**
   * The message of the first error in `errors`.
   * @return value or {@code null} for none
   */
  public java.lang.String getMessage() {
    return message;
  }

  /**
   * The message of the first error in `errors`.
   * @param message message or {@code null} for none
   */
  public Errors setMessage(java.lang.String message) {
    this.message = message;
    return this;
  }

  @Override
  public Errors set(String fieldName, Object value) {
    return (Errors) super.set(fieldName, value);
  }

  @Override
  public Errors clone() {
    return (Errors) super.clone();
  }

}
