/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Omnichannel experience details.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiaOmnichannelExperience extends com.google.api.client.json.GenericJson {

  /**
   * The CLDR country code (for example, "US").
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String country;

  /**
   * The Local Store Front (LSF) type for this country. Acceptable values are: - "`ghlsf`" (Google-
   * Hosted Local Store Front) - "`mhlsfBasic`" (Merchant-Hosted Local Store Front Basic) -
   * "`mhlsfFull`" (Merchant-Hosted Local Store Front Full) More details about these types can be
   * found here.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lsfType;

  /**
   * The Pickup types for this country. Acceptable values are: - "`pickupToday`" - "`pickupLater`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> pickupTypes;

  /**
   * The CLDR country code (for example, "US").
   * @return value or {@code null} for none
   */
  public java.lang.String getCountry() {
    return country;
  }

  /**
   * The CLDR country code (for example, "US").
   * @param country country or {@code null} for none
   */
  public LiaOmnichannelExperience setCountry(java.lang.String country) {
    this.country = country;
    return this;
  }

  /**
   * The Local Store Front (LSF) type for this country. Acceptable values are: - "`ghlsf`" (Google-
   * Hosted Local Store Front) - "`mhlsfBasic`" (Merchant-Hosted Local Store Front Basic) -
   * "`mhlsfFull`" (Merchant-Hosted Local Store Front Full) More details about these types can be
   * found here.
   * @return value or {@code null} for none
   */
  public java.lang.String getLsfType() {
    return lsfType;
  }

  /**
   * The Local Store Front (LSF) type for this country. Acceptable values are: - "`ghlsf`" (Google-
   * Hosted Local Store Front) - "`mhlsfBasic`" (Merchant-Hosted Local Store Front Basic) -
   * "`mhlsfFull`" (Merchant-Hosted Local Store Front Full) More details about these types can be
   * found here.
   * @param lsfType lsfType or {@code null} for none
   */
  public LiaOmnichannelExperience setLsfType(java.lang.String lsfType) {
    this.lsfType = lsfType;
    return this;
  }

  /**
   * The Pickup types for this country. Acceptable values are: - "`pickupToday`" - "`pickupLater`"
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPickupTypes() {
    return pickupTypes;
  }

  /**
   * The Pickup types for this country. Acceptable values are: - "`pickupToday`" - "`pickupLater`"
   * @param pickupTypes pickupTypes or {@code null} for none
   */
  public LiaOmnichannelExperience setPickupTypes(java.util.List<java.lang.String> pickupTypes) {
    this.pickupTypes = pickupTypes;
    return this;
  }

  @Override
  public LiaOmnichannelExperience set(String fieldName, Object value) {
    return (LiaOmnichannelExperience) super.set(fieldName, value);
  }

  @Override
  public LiaOmnichannelExperience clone() {
    return (LiaOmnichannelExperience) super.clone();
  }

}
