/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Local Inventory ads (LIA) settings. All methods except listposdataproviders require the admin
 * role.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiaSettings extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the account to which these LIA settings belong. Ignored upon update, always present
   * in get request responses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger accountId;

  /**
   * The LIA settings for each country.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LiaCountrySettings> countrySettings;

  static {
    // hack to force ProGuard to consider LiaCountrySettings used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(LiaCountrySettings.class);
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#liaSettings`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The ID of the account to which these LIA settings belong. Ignored upon update, always present
   * in get request responses.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getAccountId() {
    return accountId;
  }

  /**
   * The ID of the account to which these LIA settings belong. Ignored upon update, always present
   * in get request responses.
   * @param accountId accountId or {@code null} for none
   */
  public LiaSettings setAccountId(java.math.BigInteger accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * The LIA settings for each country.
   * @return value or {@code null} for none
   */
  public java.util.List<LiaCountrySettings> getCountrySettings() {
    return countrySettings;
  }

  /**
   * The LIA settings for each country.
   * @param countrySettings countrySettings or {@code null} for none
   */
  public LiaSettings setCountrySettings(java.util.List<LiaCountrySettings> countrySettings) {
    this.countrySettings = countrySettings;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#liaSettings`"
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#liaSettings`"
   * @param kind kind or {@code null} for none
   */
  public LiaSettings setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public LiaSettings set(String fieldName, Object value) {
    return (LiaSettings) super.set(fieldName, value);
  }

  @Override
  public LiaSettings clone() {
    return (LiaSettings) super.clone();
  }

}
