/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Response message for the ListConversionSources method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListConversionSourcesResponse extends com.google.api.client.json.GenericJson {

  /**
   * List of conversion sources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ConversionSource> conversionSources;

  static {
    // hack to force ProGuard to consider ConversionSource used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ConversionSource.class);
  }

  /**
   * Token to be used to fetch the next results page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * List of conversion sources.
   * @return value or {@code null} for none
   */
  public java.util.List<ConversionSource> getConversionSources() {
    return conversionSources;
  }

  /**
   * List of conversion sources.
   * @param conversionSources conversionSources or {@code null} for none
   */
  public ListConversionSourcesResponse setConversionSources(java.util.List<ConversionSource> conversionSources) {
    this.conversionSources = conversionSources;
    return this;
  }

  /**
   * Token to be used to fetch the next results page.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Token to be used to fetch the next results page.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListConversionSourcesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListConversionSourcesResponse set(String fieldName, Object value) {
    return (ListConversionSourcesResponse) super.set(fieldName, value);
  }

  @Override
  public ListConversionSourcesResponse clone() {
    return (ListConversionSourcesResponse) super.clone();
  }

}
