/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Response message for the ListMethodQuotas method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListMethodQuotasResponse extends com.google.api.client.json.GenericJson {

  /**
   * The current quota usage and limits per each method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MethodQuota> methodQuotas;

  /**
   * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted,
   * there are no subsequent pages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The current quota usage and limits per each method.
   * @return value or {@code null} for none
   */
  public java.util.List<MethodQuota> getMethodQuotas() {
    return methodQuotas;
  }

  /**
   * The current quota usage and limits per each method.
   * @param methodQuotas methodQuotas or {@code null} for none
   */
  public ListMethodQuotasResponse setMethodQuotas(java.util.List<MethodQuota> methodQuotas) {
    this.methodQuotas = methodQuotas;
    return this;
  }

  /**
   * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted,
   * there are no subsequent pages.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted,
   * there are no subsequent pages.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListMethodQuotasResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListMethodQuotasResponse set(String fieldName, Object value) {
    return (ListMethodQuotasResponse) super.set(fieldName, value);
  }

  @Override
  public ListMethodQuotasResponse clone() {
    return (ListMethodQuotasResponse) super.clone();
  }

}
