/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Local inventory resource. For accepted attribute values, see the local product inventory feed
 * specification.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LocalInventory extends com.google.api.client.json.GenericJson {

  /**
   * The availability of the product. For accepted attribute values, see the local product inventory
   * feed specification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String availability;

  /**
   * A list of custom (merchant-provided) attributes. Can also be used to submit any attribute of
   * the feed specification in its generic form, for example, `{ "name": "size type", "value":
   * "regular" }`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CustomAttribute> customAttributes;

  static {
    // hack to force ProGuard to consider CustomAttribute used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(CustomAttribute.class);
  }

  /**
   * The in-store product location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instoreProductLocation;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#localInventory`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The supported pickup method for this offer. Unless the value is "not supported", this field
   * must be submitted together with `pickupSla`. For accepted attribute values, see the local
   * product inventory feed specification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pickupMethod;

  /**
   * The expected date that an order will be ready for pickup relative to the order date. Must be
   * submitted together with `pickupMethod`. For accepted attribute values, see the local product
   * inventory feed specification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pickupSla;

  /**
   * The price of the product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price price;

  /**
   * The quantity of the product. Must be nonnegative.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long quantity;

  /**
   * The sale price of the product. Mandatory if `sale_price_effective_date` is defined.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price salePrice;

  /**
   * A date range represented by a pair of ISO 8601 dates separated by a space, comma, or slash.
   * Both dates may be specified as 'null' if undecided.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String salePriceEffectiveDate;

  /**
   * Required. The store code of this local inventory resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String storeCode;

  /**
   * The availability of the product. For accepted attribute values, see the local product inventory
   * feed specification.
   * @return value or {@code null} for none
   */
  public java.lang.String getAvailability() {
    return availability;
  }

  /**
   * The availability of the product. For accepted attribute values, see the local product inventory
   * feed specification.
   * @param availability availability or {@code null} for none
   */
  public LocalInventory setAvailability(java.lang.String availability) {
    this.availability = availability;
    return this;
  }

  /**
   * A list of custom (merchant-provided) attributes. Can also be used to submit any attribute of
   * the feed specification in its generic form, for example, `{ "name": "size type", "value":
   * "regular" }`.
   * @return value or {@code null} for none
   */
  public java.util.List<CustomAttribute> getCustomAttributes() {
    return customAttributes;
  }

  /**
   * A list of custom (merchant-provided) attributes. Can also be used to submit any attribute of
   * the feed specification in its generic form, for example, `{ "name": "size type", "value":
   * "regular" }`.
   * @param customAttributes customAttributes or {@code null} for none
   */
  public LocalInventory setCustomAttributes(java.util.List<CustomAttribute> customAttributes) {
    this.customAttributes = customAttributes;
    return this;
  }

  /**
   * The in-store product location.
   * @return value or {@code null} for none
   */
  public java.lang.String getInstoreProductLocation() {
    return instoreProductLocation;
  }

  /**
   * The in-store product location.
   * @param instoreProductLocation instoreProductLocation or {@code null} for none
   */
  public LocalInventory setInstoreProductLocation(java.lang.String instoreProductLocation) {
    this.instoreProductLocation = instoreProductLocation;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#localInventory`"
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#localInventory`"
   * @param kind kind or {@code null} for none
   */
  public LocalInventory setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The supported pickup method for this offer. Unless the value is "not supported", this field
   * must be submitted together with `pickupSla`. For accepted attribute values, see the local
   * product inventory feed specification.
   * @return value or {@code null} for none
   */
  public java.lang.String getPickupMethod() {
    return pickupMethod;
  }

  /**
   * The supported pickup method for this offer. Unless the value is "not supported", this field
   * must be submitted together with `pickupSla`. For accepted attribute values, see the local
   * product inventory feed specification.
   * @param pickupMethod pickupMethod or {@code null} for none
   */
  public LocalInventory setPickupMethod(java.lang.String pickupMethod) {
    this.pickupMethod = pickupMethod;
    return this;
  }

  /**
   * The expected date that an order will be ready for pickup relative to the order date. Must be
   * submitted together with `pickupMethod`. For accepted attribute values, see the local product
   * inventory feed specification.
   * @return value or {@code null} for none
   */
  public java.lang.String getPickupSla() {
    return pickupSla;
  }

  /**
   * The expected date that an order will be ready for pickup relative to the order date. Must be
   * submitted together with `pickupMethod`. For accepted attribute values, see the local product
   * inventory feed specification.
   * @param pickupSla pickupSla or {@code null} for none
   */
  public LocalInventory setPickupSla(java.lang.String pickupSla) {
    this.pickupSla = pickupSla;
    return this;
  }

  /**
   * The price of the product.
   * @return value or {@code null} for none
   */
  public Price getPrice() {
    return price;
  }

  /**
   * The price of the product.
   * @param price price or {@code null} for none
   */
  public LocalInventory setPrice(Price price) {
    this.price = price;
    return this;
  }

  /**
   * The quantity of the product. Must be nonnegative.
   * @return value or {@code null} for none
   */
  public java.lang.Long getQuantity() {
    return quantity;
  }

  /**
   * The quantity of the product. Must be nonnegative.
   * @param quantity quantity or {@code null} for none
   */
  public LocalInventory setQuantity(java.lang.Long quantity) {
    this.quantity = quantity;
    return this;
  }

  /**
   * The sale price of the product. Mandatory if `sale_price_effective_date` is defined.
   * @return value or {@code null} for none
   */
  public Price getSalePrice() {
    return salePrice;
  }

  /**
   * The sale price of the product. Mandatory if `sale_price_effective_date` is defined.
   * @param salePrice salePrice or {@code null} for none
   */
  public LocalInventory setSalePrice(Price salePrice) {
    this.salePrice = salePrice;
    return this;
  }

  /**
   * A date range represented by a pair of ISO 8601 dates separated by a space, comma, or slash.
   * Both dates may be specified as 'null' if undecided.
   * @return value or {@code null} for none
   */
  public java.lang.String getSalePriceEffectiveDate() {
    return salePriceEffectiveDate;
  }

  /**
   * A date range represented by a pair of ISO 8601 dates separated by a space, comma, or slash.
   * Both dates may be specified as 'null' if undecided.
   * @param salePriceEffectiveDate salePriceEffectiveDate or {@code null} for none
   */
  public LocalInventory setSalePriceEffectiveDate(java.lang.String salePriceEffectiveDate) {
    this.salePriceEffectiveDate = salePriceEffectiveDate;
    return this;
  }

  /**
   * Required. The store code of this local inventory resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getStoreCode() {
    return storeCode;
  }

  /**
   * Required. The store code of this local inventory resource.
   * @param storeCode storeCode or {@code null} for none
   */
  public LocalInventory setStoreCode(java.lang.String storeCode) {
    this.storeCode = storeCode;
    return this;
  }

  @Override
  public LocalInventory set(String fieldName, Object value) {
    return (LocalInventory) super.set(fieldName, value);
  }

  @Override
  public LocalInventory clone() {
    return (LocalInventory) super.clone();
  }

}
