/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * "Merchant Center Destination" sources can be used to send conversion events from a website using
 * a Google tag directly to a Merchant Center account where the source is created.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MerchantCenterDestination extends com.google.api.client.json.GenericJson {

  /**
   * Required. Attribution settings being used for the Merchant Center Destination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AttributionSettings attributionSettings;

  /**
   * Required. Three-letter currency code (ISO 4217). The currency code defines in which currency
   * the conversions sent to this destination will be reported in Merchant Center.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currencyCode;

  /**
   * Output only. Merchant Center Destination ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destinationId;

  /**
   * Required. Merchant-specified display name for the destination. This is the name that identifies
   * the conversion source within the Merchant Center UI. Limited to 64 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Required. Attribution settings being used for the Merchant Center Destination.
   * @return value or {@code null} for none
   */
  public AttributionSettings getAttributionSettings() {
    return attributionSettings;
  }

  /**
   * Required. Attribution settings being used for the Merchant Center Destination.
   * @param attributionSettings attributionSettings or {@code null} for none
   */
  public MerchantCenterDestination setAttributionSettings(AttributionSettings attributionSettings) {
    this.attributionSettings = attributionSettings;
    return this;
  }

  /**
   * Required. Three-letter currency code (ISO 4217). The currency code defines in which currency
   * the conversions sent to this destination will be reported in Merchant Center.
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrencyCode() {
    return currencyCode;
  }

  /**
   * Required. Three-letter currency code (ISO 4217). The currency code defines in which currency
   * the conversions sent to this destination will be reported in Merchant Center.
   * @param currencyCode currencyCode or {@code null} for none
   */
  public MerchantCenterDestination setCurrencyCode(java.lang.String currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Output only. Merchant Center Destination ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getDestinationId() {
    return destinationId;
  }

  /**
   * Output only. Merchant Center Destination ID.
   * @param destinationId destinationId or {@code null} for none
   */
  public MerchantCenterDestination setDestinationId(java.lang.String destinationId) {
    this.destinationId = destinationId;
    return this;
  }

  /**
   * Required. Merchant-specified display name for the destination. This is the name that identifies
   * the conversion source within the Merchant Center UI. Limited to 64 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Required. Merchant-specified display name for the destination. This is the name that identifies
   * the conversion source within the Merchant Center UI. Limited to 64 characters.
   * @param displayName displayName or {@code null} for none
   */
  public MerchantCenterDestination setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  @Override
  public MerchantCenterDestination set(String fieldName, Object value) {
    return (MerchantCenterDestination) super.set(fieldName, value);
  }

  @Override
  public MerchantCenterDestination clone() {
    return (MerchantCenterDestination) super.clone();
  }

}
