/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrderCancellation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderCancellation extends com.google.api.client.json.GenericJson {

  /**
   * The actor that created the cancellation. Acceptable values are: - "`customer`" - "`googleBot`"
   * - "`googleCustomerService`" - "`googlePayments`" - "`googleSabre`" - "`merchant`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String actor;

  /**
   * Date on which the cancellation has been created, in ISO 8601 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationDate;

  /**
   * The quantity that was canceled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long quantity;

  /**
   * The reason for the cancellation. Orders that are canceled with a noInventory reason will lead
   * to the removal of the product from Buy on Google until you make an update to that product. This
   * won't affect your Shopping ads. Acceptable values are: - "`autoPostInternal`" -
   * "`autoPostInvalidBillingAddress`" - "`autoPostNoInventory`" - "`autoPostPriceError`" -
   * "`autoPostUndeliverableShippingAddress`" - "`couponAbuse`" - "`customerCanceled`" -
   * "`customerInitiatedCancel`" - "`customerSupportRequested`" - "`failToPushOrderGoogleError`" -
   * "`failToPushOrderMerchantError`" - "`failToPushOrderMerchantFulfillmentError`" -
   * "`failToPushOrderToMerchant`" - "`failToPushOrderToMerchantOutOfStock`" - "`invalidCoupon`" -
   * "`malformedShippingAddress`" - "`merchantDidNotShipOnTime`" - "`noInventory`" -
   * "`orderTimeout`" - "`other`" - "`paymentAbuse`" - "`paymentDeclined`" - "`priceError`" -
   * "`returnRefundAbuse`" - "`shippingPriceError`" - "`taxError`" -
   * "`undeliverableShippingAddress`" - "`unsupportedPoBoxAddress`" - "`failedToCaptureFunds`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reason;

  /**
   * The explanation of the reason.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reasonText;

  /**
   * The actor that created the cancellation. Acceptable values are: - "`customer`" - "`googleBot`"
   * - "`googleCustomerService`" - "`googlePayments`" - "`googleSabre`" - "`merchant`"
   * @return value or {@code null} for none
   */
  public java.lang.String getActor() {
    return actor;
  }

  /**
   * The actor that created the cancellation. Acceptable values are: - "`customer`" - "`googleBot`"
   * - "`googleCustomerService`" - "`googlePayments`" - "`googleSabre`" - "`merchant`"
   * @param actor actor or {@code null} for none
   */
  public OrderCancellation setActor(java.lang.String actor) {
    this.actor = actor;
    return this;
  }

  /**
   * Date on which the cancellation has been created, in ISO 8601 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationDate() {
    return creationDate;
  }

  /**
   * Date on which the cancellation has been created, in ISO 8601 format.
   * @param creationDate creationDate or {@code null} for none
   */
  public OrderCancellation setCreationDate(java.lang.String creationDate) {
    this.creationDate = creationDate;
    return this;
  }

  /**
   * The quantity that was canceled.
   * @return value or {@code null} for none
   */
  public java.lang.Long getQuantity() {
    return quantity;
  }

  /**
   * The quantity that was canceled.
   * @param quantity quantity or {@code null} for none
   */
  public OrderCancellation setQuantity(java.lang.Long quantity) {
    this.quantity = quantity;
    return this;
  }

  /**
   * The reason for the cancellation. Orders that are canceled with a noInventory reason will lead
   * to the removal of the product from Buy on Google until you make an update to that product. This
   * won't affect your Shopping ads. Acceptable values are: - "`autoPostInternal`" -
   * "`autoPostInvalidBillingAddress`" - "`autoPostNoInventory`" - "`autoPostPriceError`" -
   * "`autoPostUndeliverableShippingAddress`" - "`couponAbuse`" - "`customerCanceled`" -
   * "`customerInitiatedCancel`" - "`customerSupportRequested`" - "`failToPushOrderGoogleError`" -
   * "`failToPushOrderMerchantError`" - "`failToPushOrderMerchantFulfillmentError`" -
   * "`failToPushOrderToMerchant`" - "`failToPushOrderToMerchantOutOfStock`" - "`invalidCoupon`" -
   * "`malformedShippingAddress`" - "`merchantDidNotShipOnTime`" - "`noInventory`" -
   * "`orderTimeout`" - "`other`" - "`paymentAbuse`" - "`paymentDeclined`" - "`priceError`" -
   * "`returnRefundAbuse`" - "`shippingPriceError`" - "`taxError`" -
   * "`undeliverableShippingAddress`" - "`unsupportedPoBoxAddress`" - "`failedToCaptureFunds`"
   * @return value or {@code null} for none
   */
  public java.lang.String getReason() {
    return reason;
  }

  /**
   * The reason for the cancellation. Orders that are canceled with a noInventory reason will lead
   * to the removal of the product from Buy on Google until you make an update to that product. This
   * won't affect your Shopping ads. Acceptable values are: - "`autoPostInternal`" -
   * "`autoPostInvalidBillingAddress`" - "`autoPostNoInventory`" - "`autoPostPriceError`" -
   * "`autoPostUndeliverableShippingAddress`" - "`couponAbuse`" - "`customerCanceled`" -
   * "`customerInitiatedCancel`" - "`customerSupportRequested`" - "`failToPushOrderGoogleError`" -
   * "`failToPushOrderMerchantError`" - "`failToPushOrderMerchantFulfillmentError`" -
   * "`failToPushOrderToMerchant`" - "`failToPushOrderToMerchantOutOfStock`" - "`invalidCoupon`" -
   * "`malformedShippingAddress`" - "`merchantDidNotShipOnTime`" - "`noInventory`" -
   * "`orderTimeout`" - "`other`" - "`paymentAbuse`" - "`paymentDeclined`" - "`priceError`" -
   * "`returnRefundAbuse`" - "`shippingPriceError`" - "`taxError`" -
   * "`undeliverableShippingAddress`" - "`unsupportedPoBoxAddress`" - "`failedToCaptureFunds`"
   * @param reason reason or {@code null} for none
   */
  public OrderCancellation setReason(java.lang.String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * The explanation of the reason.
   * @return value or {@code null} for none
   */
  public java.lang.String getReasonText() {
    return reasonText;
  }

  /**
   * The explanation of the reason.
   * @param reasonText reasonText or {@code null} for none
   */
  public OrderCancellation setReasonText(java.lang.String reasonText) {
    this.reasonText = reasonText;
    return this;
  }

  @Override
  public OrderCancellation set(String fieldName, Object value) {
    return (OrderCancellation) super.set(fieldName, value);
  }

  @Override
  public OrderCancellation clone() {
    return (OrderCancellation) super.clone();
  }

}
