/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Represents a merchant trade from which signals are extracted, e.g. shipping.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderTrackingSignal extends com.google.api.client.json.GenericJson {

  /**
   * The shipping fee of the order; this value should be set to zero in the case of free shipping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PriceAmount customerShippingFee;

  /**
   * Required. The delivery postal code, as a continuous string without spaces or dashes, e.g.
   * "95016". This field will be anonymized in returned OrderTrackingSignal creation response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deliveryPostalCode;

  /**
   * Required. The [CLDR territory code]
   * (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) for the shipping
   * destination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deliveryRegionCode;

  /**
   * Information about line items in the order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrderTrackingSignalLineItemDetails> lineItems;

  /**
   * The Google merchant ID of this order tracking signal. This value is optional. If left unset,
   * the caller's merchant ID is used. You must request access in order to provide data on behalf of
   * another merchant. For more information, see [Submitting Order Tracking Signals](/shopping-
   * content/guides/order-tracking-signals).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long merchantId;

  /**
   * Required. The time when the order was created on the merchant side. Include the year and
   * timezone string, if available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime orderCreatedTime;

  /**
   * Required. The ID of the order on the merchant side. This field will be hashed in returned
   * OrderTrackingSignal creation response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String orderId;

  /**
   * Output only. The ID that uniquely identifies this order tracking signal.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long orderTrackingSignalId;

  /**
   * The mapping of the line items to the shipment information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrderTrackingSignalShipmentLineItemMapping> shipmentLineItemMapping;

  /**
   * The shipping information for the order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrderTrackingSignalShippingInfo> shippingInfo;

  /**
   * The shipping fee of the order; this value should be set to zero in the case of free shipping.
   * @return value or {@code null} for none
   */
  public PriceAmount getCustomerShippingFee() {
    return customerShippingFee;
  }

  /**
   * The shipping fee of the order; this value should be set to zero in the case of free shipping.
   * @param customerShippingFee customerShippingFee or {@code null} for none
   */
  public OrderTrackingSignal setCustomerShippingFee(PriceAmount customerShippingFee) {
    this.customerShippingFee = customerShippingFee;
    return this;
  }

  /**
   * Required. The delivery postal code, as a continuous string without spaces or dashes, e.g.
   * "95016". This field will be anonymized in returned OrderTrackingSignal creation response.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeliveryPostalCode() {
    return deliveryPostalCode;
  }

  /**
   * Required. The delivery postal code, as a continuous string without spaces or dashes, e.g.
   * "95016". This field will be anonymized in returned OrderTrackingSignal creation response.
   * @param deliveryPostalCode deliveryPostalCode or {@code null} for none
   */
  public OrderTrackingSignal setDeliveryPostalCode(java.lang.String deliveryPostalCode) {
    this.deliveryPostalCode = deliveryPostalCode;
    return this;
  }

  /**
   * Required. The [CLDR territory code]
   * (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) for the shipping
   * destination.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeliveryRegionCode() {
    return deliveryRegionCode;
  }

  /**
   * Required. The [CLDR territory code]
   * (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) for the shipping
   * destination.
   * @param deliveryRegionCode deliveryRegionCode or {@code null} for none
   */
  public OrderTrackingSignal setDeliveryRegionCode(java.lang.String deliveryRegionCode) {
    this.deliveryRegionCode = deliveryRegionCode;
    return this;
  }

  /**
   * Information about line items in the order.
   * @return value or {@code null} for none
   */
  public java.util.List<OrderTrackingSignalLineItemDetails> getLineItems() {
    return lineItems;
  }

  /**
   * Information about line items in the order.
   * @param lineItems lineItems or {@code null} for none
   */
  public OrderTrackingSignal setLineItems(java.util.List<OrderTrackingSignalLineItemDetails> lineItems) {
    this.lineItems = lineItems;
    return this;
  }

  /**
   * The Google merchant ID of this order tracking signal. This value is optional. If left unset,
   * the caller's merchant ID is used. You must request access in order to provide data on behalf of
   * another merchant. For more information, see [Submitting Order Tracking Signals](/shopping-
   * content/guides/order-tracking-signals).
   * @return value or {@code null} for none
   */
  public java.lang.Long getMerchantId() {
    return merchantId;
  }

  /**
   * The Google merchant ID of this order tracking signal. This value is optional. If left unset,
   * the caller's merchant ID is used. You must request access in order to provide data on behalf of
   * another merchant. For more information, see [Submitting Order Tracking Signals](/shopping-
   * content/guides/order-tracking-signals).
   * @param merchantId merchantId or {@code null} for none
   */
  public OrderTrackingSignal setMerchantId(java.lang.Long merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  /**
   * Required. The time when the order was created on the merchant side. Include the year and
   * timezone string, if available.
   * @return value or {@code null} for none
   */
  public DateTime getOrderCreatedTime() {
    return orderCreatedTime;
  }

  /**
   * Required. The time when the order was created on the merchant side. Include the year and
   * timezone string, if available.
   * @param orderCreatedTime orderCreatedTime or {@code null} for none
   */
  public OrderTrackingSignal setOrderCreatedTime(DateTime orderCreatedTime) {
    this.orderCreatedTime = orderCreatedTime;
    return this;
  }

  /**
   * Required. The ID of the order on the merchant side. This field will be hashed in returned
   * OrderTrackingSignal creation response.
   * @return value or {@code null} for none
   */
  public java.lang.String getOrderId() {
    return orderId;
  }

  /**
   * Required. The ID of the order on the merchant side. This field will be hashed in returned
   * OrderTrackingSignal creation response.
   * @param orderId orderId or {@code null} for none
   */
  public OrderTrackingSignal setOrderId(java.lang.String orderId) {
    this.orderId = orderId;
    return this;
  }

  /**
   * Output only. The ID that uniquely identifies this order tracking signal.
   * @return value or {@code null} for none
   */
  public java.lang.Long getOrderTrackingSignalId() {
    return orderTrackingSignalId;
  }

  /**
   * Output only. The ID that uniquely identifies this order tracking signal.
   * @param orderTrackingSignalId orderTrackingSignalId or {@code null} for none
   */
  public OrderTrackingSignal setOrderTrackingSignalId(java.lang.Long orderTrackingSignalId) {
    this.orderTrackingSignalId = orderTrackingSignalId;
    return this;
  }

  /**
   * The mapping of the line items to the shipment information.
   * @return value or {@code null} for none
   */
  public java.util.List<OrderTrackingSignalShipmentLineItemMapping> getShipmentLineItemMapping() {
    return shipmentLineItemMapping;
  }

  /**
   * The mapping of the line items to the shipment information.
   * @param shipmentLineItemMapping shipmentLineItemMapping or {@code null} for none
   */
  public OrderTrackingSignal setShipmentLineItemMapping(java.util.List<OrderTrackingSignalShipmentLineItemMapping> shipmentLineItemMapping) {
    this.shipmentLineItemMapping = shipmentLineItemMapping;
    return this;
  }

  /**
   * The shipping information for the order.
   * @return value or {@code null} for none
   */
  public java.util.List<OrderTrackingSignalShippingInfo> getShippingInfo() {
    return shippingInfo;
  }

  /**
   * The shipping information for the order.
   * @param shippingInfo shippingInfo or {@code null} for none
   */
  public OrderTrackingSignal setShippingInfo(java.util.List<OrderTrackingSignalShippingInfo> shippingInfo) {
    this.shippingInfo = shippingInfo;
    return this;
  }

  @Override
  public OrderTrackingSignal set(String fieldName, Object value) {
    return (OrderTrackingSignal) super.set(fieldName, value);
  }

  @Override
  public OrderTrackingSignal clone() {
    return (OrderTrackingSignal) super.clone();
  }

}
