/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The shipping information for the order.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderTrackingSignalShippingInfo extends com.google.api.client.json.GenericJson {

  /**
   * The time when the shipment was actually delivered. Include the year and timezone string, if
   * available. This field is required, if one of the following fields is absent: tracking_id or
   * carrier_name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime actualDeliveryTime;

  /**
   * The name of the shipping carrier for the delivery. This field is required if one of the
   * following fields is absent: earliest_delivery_promise_time, latest_delivery_promise_time, and
   * actual_delivery_time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String carrierName;

  /**
   * The service type for fulfillment, e.g., GROUND, FIRST_CLASS, etc.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String carrierServiceName;

  /**
   * The earliest delivery promised time. Include the year and timezone string, if available. This
   * field is required, if one of the following fields is absent: tracking_id or carrier_name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime earliestDeliveryPromiseTime;

  /**
   * The latest delivery promised time. Include the year and timezone string, if available. This
   * field is required, if one of the following fields is absent: tracking_id or carrier_name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime latestDeliveryPromiseTime;

  /**
   * The origin postal code, as a continuous string without spaces or dashes, e.g. "95016". This
   * field will be anonymized in returned OrderTrackingSignal creation response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String originPostalCode;

  /**
   * The [CLDR territory code] (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
   * for the shipping origin.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String originRegionCode;

  /**
   * Required. The shipment ID. This field will be hashed in returned OrderTrackingSignal creation
   * response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shipmentId;

  /**
   * The time when the shipment was shipped. Include the year and timezone string, if available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime shippedTime;

  /**
   * The status of the shipment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shippingStatus;

  /**
   * The tracking ID of the shipment. This field is required if one of the following fields is
   * absent: earliest_delivery_promise_time, latest_delivery_promise_time, and actual_delivery_time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String trackingId;

  /**
   * The time when the shipment was actually delivered. Include the year and timezone string, if
   * available. This field is required, if one of the following fields is absent: tracking_id or
   * carrier_name.
   * @return value or {@code null} for none
   */
  public DateTime getActualDeliveryTime() {
    return actualDeliveryTime;
  }

  /**
   * The time when the shipment was actually delivered. Include the year and timezone string, if
   * available. This field is required, if one of the following fields is absent: tracking_id or
   * carrier_name.
   * @param actualDeliveryTime actualDeliveryTime or {@code null} for none
   */
  public OrderTrackingSignalShippingInfo setActualDeliveryTime(DateTime actualDeliveryTime) {
    this.actualDeliveryTime = actualDeliveryTime;
    return this;
  }

  /**
   * The name of the shipping carrier for the delivery. This field is required if one of the
   * following fields is absent: earliest_delivery_promise_time, latest_delivery_promise_time, and
   * actual_delivery_time.
   * @return value or {@code null} for none
   */
  public java.lang.String getCarrierName() {
    return carrierName;
  }

  /**
   * The name of the shipping carrier for the delivery. This field is required if one of the
   * following fields is absent: earliest_delivery_promise_time, latest_delivery_promise_time, and
   * actual_delivery_time.
   * @param carrierName carrierName or {@code null} for none
   */
  public OrderTrackingSignalShippingInfo setCarrierName(java.lang.String carrierName) {
    this.carrierName = carrierName;
    return this;
  }

  /**
   * The service type for fulfillment, e.g., GROUND, FIRST_CLASS, etc.
   * @return value or {@code null} for none
   */
  public java.lang.String getCarrierServiceName() {
    return carrierServiceName;
  }

  /**
   * The service type for fulfillment, e.g., GROUND, FIRST_CLASS, etc.
   * @param carrierServiceName carrierServiceName or {@code null} for none
   */
  public OrderTrackingSignalShippingInfo setCarrierServiceName(java.lang.String carrierServiceName) {
    this.carrierServiceName = carrierServiceName;
    return this;
  }

  /**
   * The earliest delivery promised time. Include the year and timezone string, if available. This
   * field is required, if one of the following fields is absent: tracking_id or carrier_name.
   * @return value or {@code null} for none
   */
  public DateTime getEarliestDeliveryPromiseTime() {
    return earliestDeliveryPromiseTime;
  }

  /**
   * The earliest delivery promised time. Include the year and timezone string, if available. This
   * field is required, if one of the following fields is absent: tracking_id or carrier_name.
   * @param earliestDeliveryPromiseTime earliestDeliveryPromiseTime or {@code null} for none
   */
  public OrderTrackingSignalShippingInfo setEarliestDeliveryPromiseTime(DateTime earliestDeliveryPromiseTime) {
    this.earliestDeliveryPromiseTime = earliestDeliveryPromiseTime;
    return this;
  }

  /**
   * The latest delivery promised time. Include the year and timezone string, if available. This
   * field is required, if one of the following fields is absent: tracking_id or carrier_name.
   * @return value or {@code null} for none
   */
  public DateTime getLatestDeliveryPromiseTime() {
    return latestDeliveryPromiseTime;
  }

  /**
   * The latest delivery promised time. Include the year and timezone string, if available. This
   * field is required, if one of the following fields is absent: tracking_id or carrier_name.
   * @param latestDeliveryPromiseTime latestDeliveryPromiseTime or {@code null} for none
   */
  public OrderTrackingSignalShippingInfo setLatestDeliveryPromiseTime(DateTime latestDeliveryPromiseTime) {
    this.latestDeliveryPromiseTime = latestDeliveryPromiseTime;
    return this;
  }

  /**
   * The origin postal code, as a continuous string without spaces or dashes, e.g. "95016". This
   * field will be anonymized in returned OrderTrackingSignal creation response.
   * @return value or {@code null} for none
   */
  public java.lang.String getOriginPostalCode() {
    return originPostalCode;
  }

  /**
   * The origin postal code, as a continuous string without spaces or dashes, e.g. "95016". This
   * field will be anonymized in returned OrderTrackingSignal creation response.
   * @param originPostalCode originPostalCode or {@code null} for none
   */
  public OrderTrackingSignalShippingInfo setOriginPostalCode(java.lang.String originPostalCode) {
    this.originPostalCode = originPostalCode;
    return this;
  }

  /**
   * The [CLDR territory code] (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
   * for the shipping origin.
   * @return value or {@code null} for none
   */
  public java.lang.String getOriginRegionCode() {
    return originRegionCode;
  }

  /**
   * The [CLDR territory code] (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
   * for the shipping origin.
   * @param originRegionCode originRegionCode or {@code null} for none
   */
  public OrderTrackingSignalShippingInfo setOriginRegionCode(java.lang.String originRegionCode) {
    this.originRegionCode = originRegionCode;
    return this;
  }

  /**
   * Required. The shipment ID. This field will be hashed in returned OrderTrackingSignal creation
   * response.
   * @return value or {@code null} for none
   */
  public java.lang.String getShipmentId() {
    return shipmentId;
  }

  /**
   * Required. The shipment ID. This field will be hashed in returned OrderTrackingSignal creation
   * response.
   * @param shipmentId shipmentId or {@code null} for none
   */
  public OrderTrackingSignalShippingInfo setShipmentId(java.lang.String shipmentId) {
    this.shipmentId = shipmentId;
    return this;
  }

  /**
   * The time when the shipment was shipped. Include the year and timezone string, if available.
   * @return value or {@code null} for none
   */
  public DateTime getShippedTime() {
    return shippedTime;
  }

  /**
   * The time when the shipment was shipped. Include the year and timezone string, if available.
   * @param shippedTime shippedTime or {@code null} for none
   */
  public OrderTrackingSignalShippingInfo setShippedTime(DateTime shippedTime) {
    this.shippedTime = shippedTime;
    return this;
  }

  /**
   * The status of the shipment.
   * @return value or {@code null} for none
   */
  public java.lang.String getShippingStatus() {
    return shippingStatus;
  }

  /**
   * The status of the shipment.
   * @param shippingStatus shippingStatus or {@code null} for none
   */
  public OrderTrackingSignalShippingInfo setShippingStatus(java.lang.String shippingStatus) {
    this.shippingStatus = shippingStatus;
    return this;
  }

  /**
   * The tracking ID of the shipment. This field is required if one of the following fields is
   * absent: earliest_delivery_promise_time, latest_delivery_promise_time, and actual_delivery_time.
   * @return value or {@code null} for none
   */
  public java.lang.String getTrackingId() {
    return trackingId;
  }

  /**
   * The tracking ID of the shipment. This field is required if one of the following fields is
   * absent: earliest_delivery_promise_time, latest_delivery_promise_time, and actual_delivery_time.
   * @param trackingId trackingId or {@code null} for none
   */
  public OrderTrackingSignalShippingInfo setTrackingId(java.lang.String trackingId) {
    this.trackingId = trackingId;
    return this;
  }

  @Override
  public OrderTrackingSignalShippingInfo set(String fieldName, Object value) {
    return (OrderTrackingSignalShippingInfo) super.set(fieldName, value);
  }

  @Override
  public OrderTrackingSignalShippingInfo clone() {
    return (OrderTrackingSignalShippingInfo) super.clone();
  }

}
