/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrderreturnsPartialRefund.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderreturnsPartialRefund extends com.google.api.client.json.GenericJson {

  /**
   * The pre-tax or post-tax amount to be refunded, depending on the location of the order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price priceAmount;

  /**
   * Tax amount to be refunded. Note: This has different meaning depending on the location of the
   * order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price taxAmount;

  /**
   * The pre-tax or post-tax amount to be refunded, depending on the location of the order.
   * @return value or {@code null} for none
   */
  public Price getPriceAmount() {
    return priceAmount;
  }

  /**
   * The pre-tax or post-tax amount to be refunded, depending on the location of the order.
   * @param priceAmount priceAmount or {@code null} for none
   */
  public OrderreturnsPartialRefund setPriceAmount(Price priceAmount) {
    this.priceAmount = priceAmount;
    return this;
  }

  /**
   * Tax amount to be refunded. Note: This has different meaning depending on the location of the
   * order.
   * @return value or {@code null} for none
   */
  public Price getTaxAmount() {
    return taxAmount;
  }

  /**
   * Tax amount to be refunded. Note: This has different meaning depending on the location of the
   * order.
   * @param taxAmount taxAmount or {@code null} for none
   */
  public OrderreturnsPartialRefund setTaxAmount(Price taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

  @Override
  public OrderreturnsPartialRefund set(String fieldName, Object value) {
    return (OrderreturnsPartialRefund) super.set(fieldName, value);
  }

  @Override
  public OrderreturnsPartialRefund clone() {
    return (OrderreturnsPartialRefund) super.clone();
  }

}
