/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrdersCustomBatchRequestEntryRefundItemItem.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrdersCustomBatchRequestEntryRefundItemItem extends com.google.api.client.json.GenericJson {

  /**
   * The total amount that is refunded. (for example, refunding $5 each for 2 products should be
   * done by setting quantity to 2 and amount to 10$) In case of multiple refunds, this should be
   * the amount you currently want to refund to the customer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MonetaryAmount amount;

  /**
   * If true, the full item will be refunded. If this is true, amount shouldn't be provided and will
   * be ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean fullRefund;

  /**
   * The ID of the line item. Either lineItemId or productId is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lineItemId;

  /**
   * The ID of the product. This is the REST ID used in the products service. Either lineItemId or
   * productId is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String productId;

  /**
   * The number of products that are refunded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer quantity;

  /**
   * The total amount that is refunded. (for example, refunding $5 each for 2 products should be
   * done by setting quantity to 2 and amount to 10$) In case of multiple refunds, this should be
   * the amount you currently want to refund to the customer.
   * @return value or {@code null} for none
   */
  public MonetaryAmount getAmount() {
    return amount;
  }

  /**
   * The total amount that is refunded. (for example, refunding $5 each for 2 products should be
   * done by setting quantity to 2 and amount to 10$) In case of multiple refunds, this should be
   * the amount you currently want to refund to the customer.
   * @param amount amount or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryRefundItemItem setAmount(MonetaryAmount amount) {
    this.amount = amount;
    return this;
  }

  /**
   * If true, the full item will be refunded. If this is true, amount shouldn't be provided and will
   * be ignored.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFullRefund() {
    return fullRefund;
  }

  /**
   * If true, the full item will be refunded. If this is true, amount shouldn't be provided and will
   * be ignored.
   * @param fullRefund fullRefund or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryRefundItemItem setFullRefund(java.lang.Boolean fullRefund) {
    this.fullRefund = fullRefund;
    return this;
  }

  /**
   * The ID of the line item. Either lineItemId or productId is required.
   * @return value or {@code null} for none
   */
  public java.lang.String getLineItemId() {
    return lineItemId;
  }

  /**
   * The ID of the line item. Either lineItemId or productId is required.
   * @param lineItemId lineItemId or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryRefundItemItem setLineItemId(java.lang.String lineItemId) {
    this.lineItemId = lineItemId;
    return this;
  }

  /**
   * The ID of the product. This is the REST ID used in the products service. Either lineItemId or
   * productId is required.
   * @return value or {@code null} for none
   */
  public java.lang.String getProductId() {
    return productId;
  }

  /**
   * The ID of the product. This is the REST ID used in the products service. Either lineItemId or
   * productId is required.
   * @param productId productId or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryRefundItemItem setProductId(java.lang.String productId) {
    this.productId = productId;
    return this;
  }

  /**
   * The number of products that are refunded.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getQuantity() {
    return quantity;
  }

  /**
   * The number of products that are refunded.
   * @param quantity quantity or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryRefundItemItem setQuantity(java.lang.Integer quantity) {
    this.quantity = quantity;
    return this;
  }

  @Override
  public OrdersCustomBatchRequestEntryRefundItemItem set(String fieldName, Object value) {
    return (OrdersCustomBatchRequestEntryRefundItemItem) super.set(fieldName, value);
  }

  @Override
  public OrdersCustomBatchRequestEntryRefundItemItem clone() {
    return (OrdersCustomBatchRequestEntryRefundItemItem) super.clone();
  }

}
