/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrdersCustomBatchRequestEntryRefundItemShipping.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrdersCustomBatchRequestEntryRefundItemShipping extends com.google.api.client.json.GenericJson {

  /**
   * The amount that is refunded. If this is not the first refund for the shipment, this should be
   * the newly refunded amount.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price amount;

  /**
   * If set to true, all shipping costs for the order will be refunded. If this is true, amount
   * shouldn't be provided and will be ignored. If set to false, submit the amount of the partial
   * shipping refund, excluding the shipping tax. The shipping tax is calculated and handled on
   * Google's side.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean fullRefund;

  /**
   * The amount that is refunded. If this is not the first refund for the shipment, this should be
   * the newly refunded amount.
   * @return value or {@code null} for none
   */
  public Price getAmount() {
    return amount;
  }

  /**
   * The amount that is refunded. If this is not the first refund for the shipment, this should be
   * the newly refunded amount.
   * @param amount amount or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryRefundItemShipping setAmount(Price amount) {
    this.amount = amount;
    return this;
  }

  /**
   * If set to true, all shipping costs for the order will be refunded. If this is true, amount
   * shouldn't be provided and will be ignored. If set to false, submit the amount of the partial
   * shipping refund, excluding the shipping tax. The shipping tax is calculated and handled on
   * Google's side.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFullRefund() {
    return fullRefund;
  }

  /**
   * If set to true, all shipping costs for the order will be refunded. If this is true, amount
   * shouldn't be provided and will be ignored. If set to false, submit the amount of the partial
   * shipping refund, excluding the shipping tax. The shipping tax is calculated and handled on
   * Google's side.
   * @param fullRefund fullRefund or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryRefundItemShipping setFullRefund(java.lang.Boolean fullRefund) {
    this.fullRefund = fullRefund;
    return this;
  }

  @Override
  public OrdersCustomBatchRequestEntryRefundItemShipping set(String fieldName, Object value) {
    return (OrdersCustomBatchRequestEntryRefundItemShipping) super.set(fieldName, value);
  }

  @Override
  public OrdersCustomBatchRequestEntryRefundItemShipping clone() {
    return (OrdersCustomBatchRequestEntryRefundItemShipping) super.clone();
  }

}
