/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The price represented as a number and currency.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PriceAmount extends com.google.api.client.json.GenericJson {

  /**
   * The currency of the price.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currency;

  /**
   * The price represented as a number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * The currency of the price.
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrency() {
    return currency;
  }

  /**
   * The currency of the price.
   * @param currency currency or {@code null} for none
   */
  public PriceAmount setCurrency(java.lang.String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * The price represented as a number.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The price represented as a number.
   * @param value value or {@code null} for none
   */
  public PriceAmount setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public PriceAmount set(String fieldName, Object value) {
    return (PriceAmount) super.set(fieldName, value);
  }

  @Override
  public PriceAmount clone() {
    return (PriceAmount) super.clone();
  }

}
