/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Price insights fields requested by the merchant in the query. Field values are only set if the
 * merchant queries `PriceInsightsProductView`. https://support.google.com/merchants/answer/11916926
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PriceInsights extends com.google.api.client.json.GenericJson {

  /**
   * The predicted change in clicks as a fraction after introducing the suggested price compared to
   * current active price. For example, 0.05 is a 5% predicted increase in clicks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double predictedClicksChangeFraction;

  /**
   * The predicted change in conversions as a fraction after introducing the suggested price
   * compared to current active price. For example, 0.05 is a 5% predicted increase in conversions).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double predictedConversionsChangeFraction;

  /**
   * *Deprecated*: This field is no longer supported and will start returning 0. The predicted
   * change in gross profit as a fraction after introducing the suggested price compared to current
   * active price. For example, 0.05 is a 5% predicted increase in gross profit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double predictedGrossProfitChangeFraction;

  /**
   * The predicted change in impressions as a fraction after introducing the suggested price
   * compared to current active price. For example, 0.05 is a 5% predicted increase in impressions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double predictedImpressionsChangeFraction;

  /**
   * *Deprecated*: This field is no longer supported and will start returning USD for all requests.
   * The predicted monthly gross profit change currency (ISO 4217 code).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String predictedMonthlyGrossProfitChangeCurrencyCode;

  /**
   * *Deprecated*: This field is no longer supported and will start returning 0. The predicted
   * change in gross profit in micros (1 millionth of a standard unit, 1 USD = 1000000 micros) after
   * introducing the suggested price for a month compared to current active price.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long predictedMonthlyGrossProfitChangeMicros;

  /**
   * The suggested price currency (ISO 4217 code).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String suggestedPriceCurrencyCode;

  /**
   * The latest suggested price in micros (1 millionth of a standard unit, 1 USD = 1000000 micros)
   * for the product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long suggestedPriceMicros;

  /**
   * The predicted change in clicks as a fraction after introducing the suggested price compared to
   * current active price. For example, 0.05 is a 5% predicted increase in clicks.
   * @return value or {@code null} for none
   */
  public java.lang.Double getPredictedClicksChangeFraction() {
    return predictedClicksChangeFraction;
  }

  /**
   * The predicted change in clicks as a fraction after introducing the suggested price compared to
   * current active price. For example, 0.05 is a 5% predicted increase in clicks.
   * @param predictedClicksChangeFraction predictedClicksChangeFraction or {@code null} for none
   */
  public PriceInsights setPredictedClicksChangeFraction(java.lang.Double predictedClicksChangeFraction) {
    this.predictedClicksChangeFraction = predictedClicksChangeFraction;
    return this;
  }

  /**
   * The predicted change in conversions as a fraction after introducing the suggested price
   * compared to current active price. For example, 0.05 is a 5% predicted increase in conversions).
   * @return value or {@code null} for none
   */
  public java.lang.Double getPredictedConversionsChangeFraction() {
    return predictedConversionsChangeFraction;
  }

  /**
   * The predicted change in conversions as a fraction after introducing the suggested price
   * compared to current active price. For example, 0.05 is a 5% predicted increase in conversions).
   * @param predictedConversionsChangeFraction predictedConversionsChangeFraction or {@code null} for none
   */
  public PriceInsights setPredictedConversionsChangeFraction(java.lang.Double predictedConversionsChangeFraction) {
    this.predictedConversionsChangeFraction = predictedConversionsChangeFraction;
    return this;
  }

  /**
   * *Deprecated*: This field is no longer supported and will start returning 0. The predicted
   * change in gross profit as a fraction after introducing the suggested price compared to current
   * active price. For example, 0.05 is a 5% predicted increase in gross profit.
   * @return value or {@code null} for none
   */
  public java.lang.Double getPredictedGrossProfitChangeFraction() {
    return predictedGrossProfitChangeFraction;
  }

  /**
   * *Deprecated*: This field is no longer supported and will start returning 0. The predicted
   * change in gross profit as a fraction after introducing the suggested price compared to current
   * active price. For example, 0.05 is a 5% predicted increase in gross profit.
   * @param predictedGrossProfitChangeFraction predictedGrossProfitChangeFraction or {@code null} for none
   */
  public PriceInsights setPredictedGrossProfitChangeFraction(java.lang.Double predictedGrossProfitChangeFraction) {
    this.predictedGrossProfitChangeFraction = predictedGrossProfitChangeFraction;
    return this;
  }

  /**
   * The predicted change in impressions as a fraction after introducing the suggested price
   * compared to current active price. For example, 0.05 is a 5% predicted increase in impressions.
   * @return value or {@code null} for none
   */
  public java.lang.Double getPredictedImpressionsChangeFraction() {
    return predictedImpressionsChangeFraction;
  }

  /**
   * The predicted change in impressions as a fraction after introducing the suggested price
   * compared to current active price. For example, 0.05 is a 5% predicted increase in impressions.
   * @param predictedImpressionsChangeFraction predictedImpressionsChangeFraction or {@code null} for none
   */
  public PriceInsights setPredictedImpressionsChangeFraction(java.lang.Double predictedImpressionsChangeFraction) {
    this.predictedImpressionsChangeFraction = predictedImpressionsChangeFraction;
    return this;
  }

  /**
   * *Deprecated*: This field is no longer supported and will start returning USD for all requests.
   * The predicted monthly gross profit change currency (ISO 4217 code).
   * @return value or {@code null} for none
   */
  public java.lang.String getPredictedMonthlyGrossProfitChangeCurrencyCode() {
    return predictedMonthlyGrossProfitChangeCurrencyCode;
  }

  /**
   * *Deprecated*: This field is no longer supported and will start returning USD for all requests.
   * The predicted monthly gross profit change currency (ISO 4217 code).
   * @param predictedMonthlyGrossProfitChangeCurrencyCode predictedMonthlyGrossProfitChangeCurrencyCode or {@code null} for none
   */
  public PriceInsights setPredictedMonthlyGrossProfitChangeCurrencyCode(java.lang.String predictedMonthlyGrossProfitChangeCurrencyCode) {
    this.predictedMonthlyGrossProfitChangeCurrencyCode = predictedMonthlyGrossProfitChangeCurrencyCode;
    return this;
  }

  /**
   * *Deprecated*: This field is no longer supported and will start returning 0. The predicted
   * change in gross profit in micros (1 millionth of a standard unit, 1 USD = 1000000 micros) after
   * introducing the suggested price for a month compared to current active price.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPredictedMonthlyGrossProfitChangeMicros() {
    return predictedMonthlyGrossProfitChangeMicros;
  }

  /**
   * *Deprecated*: This field is no longer supported and will start returning 0. The predicted
   * change in gross profit in micros (1 millionth of a standard unit, 1 USD = 1000000 micros) after
   * introducing the suggested price for a month compared to current active price.
   * @param predictedMonthlyGrossProfitChangeMicros predictedMonthlyGrossProfitChangeMicros or {@code null} for none
   */
  public PriceInsights setPredictedMonthlyGrossProfitChangeMicros(java.lang.Long predictedMonthlyGrossProfitChangeMicros) {
    this.predictedMonthlyGrossProfitChangeMicros = predictedMonthlyGrossProfitChangeMicros;
    return this;
  }

  /**
   * The suggested price currency (ISO 4217 code).
   * @return value or {@code null} for none
   */
  public java.lang.String getSuggestedPriceCurrencyCode() {
    return suggestedPriceCurrencyCode;
  }

  /**
   * The suggested price currency (ISO 4217 code).
   * @param suggestedPriceCurrencyCode suggestedPriceCurrencyCode or {@code null} for none
   */
  public PriceInsights setSuggestedPriceCurrencyCode(java.lang.String suggestedPriceCurrencyCode) {
    this.suggestedPriceCurrencyCode = suggestedPriceCurrencyCode;
    return this;
  }

  /**
   * The latest suggested price in micros (1 millionth of a standard unit, 1 USD = 1000000 micros)
   * for the product.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSuggestedPriceMicros() {
    return suggestedPriceMicros;
  }

  /**
   * The latest suggested price in micros (1 millionth of a standard unit, 1 USD = 1000000 micros)
   * for the product.
   * @param suggestedPriceMicros suggestedPriceMicros or {@code null} for none
   */
  public PriceInsights setSuggestedPriceMicros(java.lang.Long suggestedPriceMicros) {
    this.suggestedPriceMicros = suggestedPriceMicros;
    return this;
  }

  @Override
  public PriceInsights set(String fieldName, Object value) {
    return (PriceInsights) super.set(fieldName, value);
  }

  @Override
  public PriceInsights clone() {
    return (PriceInsights) super.clone();
  }

}
