/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Required product attributes are primarily defined by the product data specification. See the
 * Product Data Specification Help Center article for information. Product data. After inserting,
 * updating, or deleting a product, it may take several minutes before changes take effect.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Product extends com.google.api.client.json.GenericJson {

  /**
   * Additional URLs of images of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> additionalImageLinks;

  /**
   * Additional cut of the item. Used together with size_type to represent combined size types for
   * apparel items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String additionalSizeType;

  /**
   * Used to group items in an arbitrary way. Only for CPA%, discouraged otherwise.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String adsGrouping;

  /**
   * Similar to ads_grouping, but only works on CPC.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> adsLabels;

  /**
   * Allows advertisers to override the item URL when the product is shown within the context of
   * Product Ads.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String adsRedirect;

  /**
   * Should be set to true if the item is targeted towards adults.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean adult;

  /**
   * Target age group of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ageGroup;

  /**
   * Availability status of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String availability;

  /**
   * The day a pre-ordered product becomes available for delivery, in ISO 8601 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String availabilityDate;

  /**
   * Brand of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String brand;

  /**
   * URL for the canonical version of your item's landing page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String canonicalLink;

  /**
   * Product [certification](https://support.google.com/merchants/answer/13528839), introduced for
   * EU energy efficiency labeling compliance using the [EU
   * EPREL](https://eprel.ec.europa.eu/screen/home) database.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ProductCertification> certifications;

  /**
   * Required. The item's channel (online or local). Acceptable values are: - "`local`" - "`online`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String channel;

  /**
   * Extra fields to export to the Cloud Retail program.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CloudExportAdditionalProperties> cloudExportAdditionalProperties;

  static {
    // hack to force ProGuard to consider CloudExportAdditionalProperties used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(CloudExportAdditionalProperties.class);
  }

  /**
   * Color of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String color;

  /**
   * Condition or state of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String condition;

  /**
   * Required. The two-letter ISO 639-1 language code for the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentLanguage;

  /**
   * Cost of goods sold. Used for gross profit reporting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price costOfGoodsSold;

  /**
   * A list of custom (merchant-provided) attributes. It can also be used for submitting any
   * attribute of the feed specification in its generic form (for example, `{ "name": "size type",
   * "value": "regular" }`). This is useful for submitting attributes not explicitly exposed by the
   * API, such as additional attributes used for Buy on Google (formerly known as Shopping Actions).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CustomAttribute> customAttributes;

  static {
    // hack to force ProGuard to consider CustomAttribute used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(CustomAttribute.class);
  }

  /**
   * Custom label 0 for custom grouping of items in a Shopping campaign.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customLabel0;

  /**
   * Custom label 1 for custom grouping of items in a Shopping campaign.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customLabel1;

  /**
   * Custom label 2 for custom grouping of items in a Shopping campaign.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customLabel2;

  /**
   * Custom label 3 for custom grouping of items in a Shopping campaign.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customLabel3;

  /**
   * Custom label 4 for custom grouping of items in a Shopping campaign.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customLabel4;

  /**
   * Description of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The date time when an offer becomes visible in search results across Google’s YouTube surfaces,
   * in [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format. See [Disclosure
   * date](https://support.google.com/merchants/answer/13034208) for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String disclosureDate;

  /**
   * An identifier for an item for dynamic remarketing campaigns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayAdsId;

  /**
   * URL directly to your item's landing page for dynamic remarketing campaigns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayAdsLink;

  /**
   * Advertiser-specified recommendations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> displayAdsSimilarIds;

  /**
   * Title of an item for dynamic remarketing campaigns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayAdsTitle;

  /**
   * Offer margin for dynamic remarketing campaigns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double displayAdsValue;

  /**
   * The energy efficiency class as defined in EU directive 2010/30/EU.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String energyEfficiencyClass;

  /**
   * The list of destinations to exclude for this target (corresponds to cleared check boxes in
   * Merchant Center). Products that are excluded from all destinations for more than 7 days are
   * automatically deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> excludedDestinations;

  /**
   * Date on which the item should expire, as specified upon insertion, in ISO 8601 format. The
   * actual expiration date in Google Shopping is exposed in `productstatuses` as
   * `googleExpirationDate` and might be earlier if `expirationDate` is too far in the future.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String expirationDate;

  /**
   * Required for multi-seller accounts. Use this attribute if you're a marketplace uploading
   * products for various sellers to your multi-seller account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String externalSellerId;

  /**
   * Feed label for the item. Either `targetCountry` or `feedLabel` is required. Must be less than
   * or equal to 20 uppercase letters (A-Z), numbers (0-9), and dashes (-).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String feedLabel;

  /**
   * Target gender of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gender;

  /**
   * Google's category of the item (see [Google product
   * taxonomy](https://support.google.com/merchants/answer/1705911)). When querying products, this
   * field will contain the user provided value. There is currently no way to get back the auto
   * assigned google product categories through the API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String googleProductCategory;

  /**
   * Global Trade Item Number (GTIN) of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gtin;

  /**
   * The REST ID of the product. Content API methods that operate on products take this as their
   * `productId` parameter. The REST ID for a product has one of the 2 forms
   * channel:contentLanguage: targetCountry: offerId or channel:contentLanguage:feedLabel: offerId.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * False when the item does not have unique product identifiers appropriate to its category, such
   * as GTIN, MPN, and brand. Required according to the Unique Product Identifier Rules for all
   * target countries except for Canada.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean identifierExists;

  /**
   * URL of an image of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String imageLink;

  /**
   * The list of destinations to include for this target (corresponds to checked check boxes in
   * Merchant Center). Default destinations are always included unless provided in
   * `excludedDestinations`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> includedDestinations;

  /**
   * Number and amount of installments to pay for an item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Installment installment;

  /**
   * Whether the item is a merchant-defined bundle. A bundle is a custom grouping of different
   * products sold by a merchant for a single price.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isBundle;

  /**
   * Shared identifier for all variants of the same product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String itemGroupId;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#product`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Additional URLs of lifestyle images of the item. Used to explicitly identify images that
   * showcase your item in a real-world context. See the Help Center article for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> lifestyleImageLinks;

  /**
   * URL directly linking to your item's page on your website.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String link;

  /**
   * URL template for merchant hosted local storefront.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String linkTemplate;

  /**
   * Loyalty points that users receive after purchasing the item. Japan only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LoyaltyPoints loyaltyPoints;

  /**
   * The material of which the item is made.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String material;

  /**
   * The energy efficiency class as defined in EU directive 2010/30/EU.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String maxEnergyEfficiencyClass;

  /**
   * Maximal product handling time (in business days).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxHandlingTime;

  /**
   * The energy efficiency class as defined in EU directive 2010/30/EU.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String minEnergyEfficiencyClass;

  /**
   * Minimal product handling time (in business days).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long minHandlingTime;

  /**
   * URL for the mobile-optimized version of your item's landing page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mobileLink;

  /**
   * URL template for merchant hosted local storefront optimized for mobile devices.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mobileLinkTemplate;

  /**
   * Manufacturer Part Number (MPN) of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mpn;

  /**
   * The number of identical products in a merchant-defined multipack.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long multipack;

  /**
   * Required. A unique identifier for the item. Leading and trailing whitespaces are stripped and
   * multiple whitespaces are replaced by a single whitespace upon submission. Only valid unicode
   * characters are accepted. See the products feed specification for details. *Note:* Content API
   * methods that operate on products take the REST ID of the product, *not* this identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String offerId;

  /**
   * The item's pattern (for example, polka dots).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pattern;

  /**
   * Publication of this item should be temporarily paused. Acceptable values are: - "`ads`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pause;

  /**
   * The pick up option for the item. Acceptable values are: - "`buy`" - "`reserve`" - "`ship to
   * store`" - "`not supported`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pickupMethod;

  /**
   * Item store pickup timeline. Acceptable values are: - "`same day`" - "`next day`" - "`2-day`" -
   * "`3-day`" - "`4-day`" - "`5-day`" - "`6-day`" - "`7-day`" - "`multi-week`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pickupSla;

  /**
   * Price of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price price;

  /**
   * Technical specification or additional product details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ProductProductDetail> productDetails;

  /**
   * The height of the product in the units provided. The value must be between 0 (exclusive) and
   * 3000 (inclusive).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProductDimension productHeight;

  /**
   * Bullet points describing the most relevant highlights of a product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> productHighlights;

  /**
   * The length of the product in the units provided. The value must be between 0 (exclusive) and
   * 3000 (inclusive).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProductDimension productLength;

  /**
   * Categories of the item (formatted as in product data specification).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> productTypes;

  /**
   * The weight of the product in the units provided. The value must be between 0 (exclusive) and
   * 2000 (inclusive).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProductWeight productWeight;

  /**
   * The width of the product in the units provided. The value must be between 0 (exclusive) and
   * 3000 (inclusive).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProductDimension productWidth;

  /**
   * The unique ID of a promotion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> promotionIds;

  /**
   * Advertised sale price of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price salePrice;

  /**
   * Date range during which the item is on sale (see product data specification ).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String salePriceEffectiveDate;

  /**
   * The quantity of the product that is available for selling on Google. Supported only for online
   * products.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long sellOnGoogleQuantity;

  /**
   * Shipping rules.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ProductShipping> shipping;

  /**
   * Height of the item for shipping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProductShippingDimension shippingHeight;

  /**
   * The shipping label of the product, used to group product in account-level shipping rules.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shippingLabel;

  /**
   * Length of the item for shipping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProductShippingDimension shippingLength;

  /**
   * Weight of the item for shipping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProductShippingWeight shippingWeight;

  /**
   * Width of the item for shipping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProductShippingDimension shippingWidth;

  /**
   * List of country codes (ISO 3166-1 alpha-2) to exclude the offer from Shopping Ads destination.
   * Countries from this list are removed from countries configured in MC feed settings.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> shoppingAdsExcludedCountries;

  /**
   * System in which the size is specified. Recommended for apparel items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sizeSystem;

  /**
   * The cut of the item. Recommended for apparel items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sizeType;

  /**
   * Size of the item. Only one value is allowed. For variants with different sizes, insert a
   * separate product for each size with the same `itemGroupId` value (see size definition).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> sizes;

  /**
   * The source of the offer, that is, how the offer was created. Acceptable values are: - "`api`" -
   * "`crawl`" - "`feed`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String source;

  /**
   * Number of periods (months or years) and amount of payment per period for an item with an
   * associated subscription contract.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProductSubscriptionCost subscriptionCost;

  /**
   * Required. The CLDR territory code for the item's country of sale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetCountry;

  /**
   * The tax category of the product, used to configure detailed tax nexus in account-level tax
   * settings.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String taxCategory;

  /**
   * Tax information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ProductTax> taxes;

  /**
   * Title of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The transit time label of the product, used to group product in account-level transit time
   * tables.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String transitTimeLabel;

  /**
   * The preference of the denominator of the unit price.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProductUnitPricingBaseMeasure unitPricingBaseMeasure;

  /**
   * The measure and dimension of an item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProductUnitPricingMeasure unitPricingMeasure;

  /**
   * URL of the 3D model of the item to provide more visuals.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String virtualModelLink;

  /**
   * Additional URLs of images of the item.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAdditionalImageLinks() {
    return additionalImageLinks;
  }

  /**
   * Additional URLs of images of the item.
   * @param additionalImageLinks additionalImageLinks or {@code null} for none
   */
  public Product setAdditionalImageLinks(java.util.List<java.lang.String> additionalImageLinks) {
    this.additionalImageLinks = additionalImageLinks;
    return this;
  }

  /**
   * Additional cut of the item. Used together with size_type to represent combined size types for
   * apparel items.
   * @return value or {@code null} for none
   */
  public java.lang.String getAdditionalSizeType() {
    return additionalSizeType;
  }

  /**
   * Additional cut of the item. Used together with size_type to represent combined size types for
   * apparel items.
   * @param additionalSizeType additionalSizeType or {@code null} for none
   */
  public Product setAdditionalSizeType(java.lang.String additionalSizeType) {
    this.additionalSizeType = additionalSizeType;
    return this;
  }

  /**
   * Used to group items in an arbitrary way. Only for CPA%, discouraged otherwise.
   * @return value or {@code null} for none
   */
  public java.lang.String getAdsGrouping() {
    return adsGrouping;
  }

  /**
   * Used to group items in an arbitrary way. Only for CPA%, discouraged otherwise.
   * @param adsGrouping adsGrouping or {@code null} for none
   */
  public Product setAdsGrouping(java.lang.String adsGrouping) {
    this.adsGrouping = adsGrouping;
    return this;
  }

  /**
   * Similar to ads_grouping, but only works on CPC.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAdsLabels() {
    return adsLabels;
  }

  /**
   * Similar to ads_grouping, but only works on CPC.
   * @param adsLabels adsLabels or {@code null} for none
   */
  public Product setAdsLabels(java.util.List<java.lang.String> adsLabels) {
    this.adsLabels = adsLabels;
    return this;
  }

  /**
   * Allows advertisers to override the item URL when the product is shown within the context of
   * Product Ads.
   * @return value or {@code null} for none
   */
  public java.lang.String getAdsRedirect() {
    return adsRedirect;
  }

  /**
   * Allows advertisers to override the item URL when the product is shown within the context of
   * Product Ads.
   * @param adsRedirect adsRedirect or {@code null} for none
   */
  public Product setAdsRedirect(java.lang.String adsRedirect) {
    this.adsRedirect = adsRedirect;
    return this;
  }

  /**
   * Should be set to true if the item is targeted towards adults.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAdult() {
    return adult;
  }

  /**
   * Should be set to true if the item is targeted towards adults.
   * @param adult adult or {@code null} for none
   */
  public Product setAdult(java.lang.Boolean adult) {
    this.adult = adult;
    return this;
  }

  /**
   * Target age group of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getAgeGroup() {
    return ageGroup;
  }

  /**
   * Target age group of the item.
   * @param ageGroup ageGroup or {@code null} for none
   */
  public Product setAgeGroup(java.lang.String ageGroup) {
    this.ageGroup = ageGroup;
    return this;
  }

  /**
   * Availability status of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getAvailability() {
    return availability;
  }

  /**
   * Availability status of the item.
   * @param availability availability or {@code null} for none
   */
  public Product setAvailability(java.lang.String availability) {
    this.availability = availability;
    return this;
  }

  /**
   * The day a pre-ordered product becomes available for delivery, in ISO 8601 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getAvailabilityDate() {
    return availabilityDate;
  }

  /**
   * The day a pre-ordered product becomes available for delivery, in ISO 8601 format.
   * @param availabilityDate availabilityDate or {@code null} for none
   */
  public Product setAvailabilityDate(java.lang.String availabilityDate) {
    this.availabilityDate = availabilityDate;
    return this;
  }

  /**
   * Brand of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getBrand() {
    return brand;
  }

  /**
   * Brand of the item.
   * @param brand brand or {@code null} for none
   */
  public Product setBrand(java.lang.String brand) {
    this.brand = brand;
    return this;
  }

  /**
   * URL for the canonical version of your item's landing page.
   * @return value or {@code null} for none
   */
  public java.lang.String getCanonicalLink() {
    return canonicalLink;
  }

  /**
   * URL for the canonical version of your item's landing page.
   * @param canonicalLink canonicalLink or {@code null} for none
   */
  public Product setCanonicalLink(java.lang.String canonicalLink) {
    this.canonicalLink = canonicalLink;
    return this;
  }

  /**
   * Product [certification](https://support.google.com/merchants/answer/13528839), introduced for
   * EU energy efficiency labeling compliance using the [EU
   * EPREL](https://eprel.ec.europa.eu/screen/home) database.
   * @return value or {@code null} for none
   */
  public java.util.List<ProductCertification> getCertifications() {
    return certifications;
  }

  /**
   * Product [certification](https://support.google.com/merchants/answer/13528839), introduced for
   * EU energy efficiency labeling compliance using the [EU
   * EPREL](https://eprel.ec.europa.eu/screen/home) database.
   * @param certifications certifications or {@code null} for none
   */
  public Product setCertifications(java.util.List<ProductCertification> certifications) {
    this.certifications = certifications;
    return this;
  }

  /**
   * Required. The item's channel (online or local). Acceptable values are: - "`local`" - "`online`"
   * @return value or {@code null} for none
   */
  public java.lang.String getChannel() {
    return channel;
  }

  /**
   * Required. The item's channel (online or local). Acceptable values are: - "`local`" - "`online`"
   * @param channel channel or {@code null} for none
   */
  public Product setChannel(java.lang.String channel) {
    this.channel = channel;
    return this;
  }

  /**
   * Extra fields to export to the Cloud Retail program.
   * @return value or {@code null} for none
   */
  public java.util.List<CloudExportAdditionalProperties> getCloudExportAdditionalProperties() {
    return cloudExportAdditionalProperties;
  }

  /**
   * Extra fields to export to the Cloud Retail program.
   * @param cloudExportAdditionalProperties cloudExportAdditionalProperties or {@code null} for none
   */
  public Product setCloudExportAdditionalProperties(java.util.List<CloudExportAdditionalProperties> cloudExportAdditionalProperties) {
    this.cloudExportAdditionalProperties = cloudExportAdditionalProperties;
    return this;
  }

  /**
   * Color of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getColor() {
    return color;
  }

  /**
   * Color of the item.
   * @param color color or {@code null} for none
   */
  public Product setColor(java.lang.String color) {
    this.color = color;
    return this;
  }

  /**
   * Condition or state of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getCondition() {
    return condition;
  }

  /**
   * Condition or state of the item.
   * @param condition condition or {@code null} for none
   */
  public Product setCondition(java.lang.String condition) {
    this.condition = condition;
    return this;
  }

  /**
   * Required. The two-letter ISO 639-1 language code for the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentLanguage() {
    return contentLanguage;
  }

  /**
   * Required. The two-letter ISO 639-1 language code for the item.
   * @param contentLanguage contentLanguage or {@code null} for none
   */
  public Product setContentLanguage(java.lang.String contentLanguage) {
    this.contentLanguage = contentLanguage;
    return this;
  }

  /**
   * Cost of goods sold. Used for gross profit reporting.
   * @return value or {@code null} for none
   */
  public Price getCostOfGoodsSold() {
    return costOfGoodsSold;
  }

  /**
   * Cost of goods sold. Used for gross profit reporting.
   * @param costOfGoodsSold costOfGoodsSold or {@code null} for none
   */
  public Product setCostOfGoodsSold(Price costOfGoodsSold) {
    this.costOfGoodsSold = costOfGoodsSold;
    return this;
  }

  /**
   * A list of custom (merchant-provided) attributes. It can also be used for submitting any
   * attribute of the feed specification in its generic form (for example, `{ "name": "size type",
   * "value": "regular" }`). This is useful for submitting attributes not explicitly exposed by the
   * API, such as additional attributes used for Buy on Google (formerly known as Shopping Actions).
   * @return value or {@code null} for none
   */
  public java.util.List<CustomAttribute> getCustomAttributes() {
    return customAttributes;
  }

  /**
   * A list of custom (merchant-provided) attributes. It can also be used for submitting any
   * attribute of the feed specification in its generic form (for example, `{ "name": "size type",
   * "value": "regular" }`). This is useful for submitting attributes not explicitly exposed by the
   * API, such as additional attributes used for Buy on Google (formerly known as Shopping Actions).
   * @param customAttributes customAttributes or {@code null} for none
   */
  public Product setCustomAttributes(java.util.List<CustomAttribute> customAttributes) {
    this.customAttributes = customAttributes;
    return this;
  }

  /**
   * Custom label 0 for custom grouping of items in a Shopping campaign.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomLabel0() {
    return customLabel0;
  }

  /**
   * Custom label 0 for custom grouping of items in a Shopping campaign.
   * @param customLabel0 customLabel0 or {@code null} for none
   */
  public Product setCustomLabel0(java.lang.String customLabel0) {
    this.customLabel0 = customLabel0;
    return this;
  }

  /**
   * Custom label 1 for custom grouping of items in a Shopping campaign.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomLabel1() {
    return customLabel1;
  }

  /**
   * Custom label 1 for custom grouping of items in a Shopping campaign.
   * @param customLabel1 customLabel1 or {@code null} for none
   */
  public Product setCustomLabel1(java.lang.String customLabel1) {
    this.customLabel1 = customLabel1;
    return this;
  }

  /**
   * Custom label 2 for custom grouping of items in a Shopping campaign.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomLabel2() {
    return customLabel2;
  }

  /**
   * Custom label 2 for custom grouping of items in a Shopping campaign.
   * @param customLabel2 customLabel2 or {@code null} for none
   */
  public Product setCustomLabel2(java.lang.String customLabel2) {
    this.customLabel2 = customLabel2;
    return this;
  }

  /**
   * Custom label 3 for custom grouping of items in a Shopping campaign.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomLabel3() {
    return customLabel3;
  }

  /**
   * Custom label 3 for custom grouping of items in a Shopping campaign.
   * @param customLabel3 customLabel3 or {@code null} for none
   */
  public Product setCustomLabel3(java.lang.String customLabel3) {
    this.customLabel3 = customLabel3;
    return this;
  }

  /**
   * Custom label 4 for custom grouping of items in a Shopping campaign.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomLabel4() {
    return customLabel4;
  }

  /**
   * Custom label 4 for custom grouping of items in a Shopping campaign.
   * @param customLabel4 customLabel4 or {@code null} for none
   */
  public Product setCustomLabel4(java.lang.String customLabel4) {
    this.customLabel4 = customLabel4;
    return this;
  }

  /**
   * Description of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Description of the item.
   * @param description description or {@code null} for none
   */
  public Product setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The date time when an offer becomes visible in search results across Google’s YouTube surfaces,
   * in [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format. See [Disclosure
   * date](https://support.google.com/merchants/answer/13034208) for more information.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisclosureDate() {
    return disclosureDate;
  }

  /**
   * The date time when an offer becomes visible in search results across Google’s YouTube surfaces,
   * in [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format. See [Disclosure
   * date](https://support.google.com/merchants/answer/13034208) for more information.
   * @param disclosureDate disclosureDate or {@code null} for none
   */
  public Product setDisclosureDate(java.lang.String disclosureDate) {
    this.disclosureDate = disclosureDate;
    return this;
  }

  /**
   * An identifier for an item for dynamic remarketing campaigns.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayAdsId() {
    return displayAdsId;
  }

  /**
   * An identifier for an item for dynamic remarketing campaigns.
   * @param displayAdsId displayAdsId or {@code null} for none
   */
  public Product setDisplayAdsId(java.lang.String displayAdsId) {
    this.displayAdsId = displayAdsId;
    return this;
  }

  /**
   * URL directly to your item's landing page for dynamic remarketing campaigns.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayAdsLink() {
    return displayAdsLink;
  }

  /**
   * URL directly to your item's landing page for dynamic remarketing campaigns.
   * @param displayAdsLink displayAdsLink or {@code null} for none
   */
  public Product setDisplayAdsLink(java.lang.String displayAdsLink) {
    this.displayAdsLink = displayAdsLink;
    return this;
  }

  /**
   * Advertiser-specified recommendations.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDisplayAdsSimilarIds() {
    return displayAdsSimilarIds;
  }

  /**
   * Advertiser-specified recommendations.
   * @param displayAdsSimilarIds displayAdsSimilarIds or {@code null} for none
   */
  public Product setDisplayAdsSimilarIds(java.util.List<java.lang.String> displayAdsSimilarIds) {
    this.displayAdsSimilarIds = displayAdsSimilarIds;
    return this;
  }

  /**
   * Title of an item for dynamic remarketing campaigns.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayAdsTitle() {
    return displayAdsTitle;
  }

  /**
   * Title of an item for dynamic remarketing campaigns.
   * @param displayAdsTitle displayAdsTitle or {@code null} for none
   */
  public Product setDisplayAdsTitle(java.lang.String displayAdsTitle) {
    this.displayAdsTitle = displayAdsTitle;
    return this;
  }

  /**
   * Offer margin for dynamic remarketing campaigns.
   * @return value or {@code null} for none
   */
  public java.lang.Double getDisplayAdsValue() {
    return displayAdsValue;
  }

  /**
   * Offer margin for dynamic remarketing campaigns.
   * @param displayAdsValue displayAdsValue or {@code null} for none
   */
  public Product setDisplayAdsValue(java.lang.Double displayAdsValue) {
    this.displayAdsValue = displayAdsValue;
    return this;
  }

  /**
   * The energy efficiency class as defined in EU directive 2010/30/EU.
   * @return value or {@code null} for none
   */
  public java.lang.String getEnergyEfficiencyClass() {
    return energyEfficiencyClass;
  }

  /**
   * The energy efficiency class as defined in EU directive 2010/30/EU.
   * @param energyEfficiencyClass energyEfficiencyClass or {@code null} for none
   */
  public Product setEnergyEfficiencyClass(java.lang.String energyEfficiencyClass) {
    this.energyEfficiencyClass = energyEfficiencyClass;
    return this;
  }

  /**
   * The list of destinations to exclude for this target (corresponds to cleared check boxes in
   * Merchant Center). Products that are excluded from all destinations for more than 7 days are
   * automatically deleted.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getExcludedDestinations() {
    return excludedDestinations;
  }

  /**
   * The list of destinations to exclude for this target (corresponds to cleared check boxes in
   * Merchant Center). Products that are excluded from all destinations for more than 7 days are
   * automatically deleted.
   * @param excludedDestinations excludedDestinations or {@code null} for none
   */
  public Product setExcludedDestinations(java.util.List<java.lang.String> excludedDestinations) {
    this.excludedDestinations = excludedDestinations;
    return this;
  }

  /**
   * Date on which the item should expire, as specified upon insertion, in ISO 8601 format. The
   * actual expiration date in Google Shopping is exposed in `productstatuses` as
   * `googleExpirationDate` and might be earlier if `expirationDate` is too far in the future.
   * @return value or {@code null} for none
   */
  public java.lang.String getExpirationDate() {
    return expirationDate;
  }

  /**
   * Date on which the item should expire, as specified upon insertion, in ISO 8601 format. The
   * actual expiration date in Google Shopping is exposed in `productstatuses` as
   * `googleExpirationDate` and might be earlier if `expirationDate` is too far in the future.
   * @param expirationDate expirationDate or {@code null} for none
   */
  public Product setExpirationDate(java.lang.String expirationDate) {
    this.expirationDate = expirationDate;
    return this;
  }

  /**
   * Required for multi-seller accounts. Use this attribute if you're a marketplace uploading
   * products for various sellers to your multi-seller account.
   * @return value or {@code null} for none
   */
  public java.lang.String getExternalSellerId() {
    return externalSellerId;
  }

  /**
   * Required for multi-seller accounts. Use this attribute if you're a marketplace uploading
   * products for various sellers to your multi-seller account.
   * @param externalSellerId externalSellerId or {@code null} for none
   */
  public Product setExternalSellerId(java.lang.String externalSellerId) {
    this.externalSellerId = externalSellerId;
    return this;
  }

  /**
   * Feed label for the item. Either `targetCountry` or `feedLabel` is required. Must be less than
   * or equal to 20 uppercase letters (A-Z), numbers (0-9), and dashes (-).
   * @return value or {@code null} for none
   */
  public java.lang.String getFeedLabel() {
    return feedLabel;
  }

  /**
   * Feed label for the item. Either `targetCountry` or `feedLabel` is required. Must be less than
   * or equal to 20 uppercase letters (A-Z), numbers (0-9), and dashes (-).
   * @param feedLabel feedLabel or {@code null} for none
   */
  public Product setFeedLabel(java.lang.String feedLabel) {
    this.feedLabel = feedLabel;
    return this;
  }

  /**
   * Target gender of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getGender() {
    return gender;
  }

  /**
   * Target gender of the item.
   * @param gender gender or {@code null} for none
   */
  public Product setGender(java.lang.String gender) {
    this.gender = gender;
    return this;
  }

  /**
   * Google's category of the item (see [Google product
   * taxonomy](https://support.google.com/merchants/answer/1705911)). When querying products, this
   * field will contain the user provided value. There is currently no way to get back the auto
   * assigned google product categories through the API.
   * @return value or {@code null} for none
   */
  public java.lang.String getGoogleProductCategory() {
    return googleProductCategory;
  }

  /**
   * Google's category of the item (see [Google product
   * taxonomy](https://support.google.com/merchants/answer/1705911)). When querying products, this
   * field will contain the user provided value. There is currently no way to get back the auto
   * assigned google product categories through the API.
   * @param googleProductCategory googleProductCategory or {@code null} for none
   */
  public Product setGoogleProductCategory(java.lang.String googleProductCategory) {
    this.googleProductCategory = googleProductCategory;
    return this;
  }

  /**
   * Global Trade Item Number (GTIN) of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getGtin() {
    return gtin;
  }

  /**
   * Global Trade Item Number (GTIN) of the item.
   * @param gtin gtin or {@code null} for none
   */
  public Product setGtin(java.lang.String gtin) {
    this.gtin = gtin;
    return this;
  }

  /**
   * The REST ID of the product. Content API methods that operate on products take this as their
   * `productId` parameter. The REST ID for a product has one of the 2 forms
   * channel:contentLanguage: targetCountry: offerId or channel:contentLanguage:feedLabel: offerId.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The REST ID of the product. Content API methods that operate on products take this as their
   * `productId` parameter. The REST ID for a product has one of the 2 forms
   * channel:contentLanguage: targetCountry: offerId or channel:contentLanguage:feedLabel: offerId.
   * @param id id or {@code null} for none
   */
  public Product setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * False when the item does not have unique product identifiers appropriate to its category, such
   * as GTIN, MPN, and brand. Required according to the Unique Product Identifier Rules for all
   * target countries except for Canada.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIdentifierExists() {
    return identifierExists;
  }

  /**
   * False when the item does not have unique product identifiers appropriate to its category, such
   * as GTIN, MPN, and brand. Required according to the Unique Product Identifier Rules for all
   * target countries except for Canada.
   * @param identifierExists identifierExists or {@code null} for none
   */
  public Product setIdentifierExists(java.lang.Boolean identifierExists) {
    this.identifierExists = identifierExists;
    return this;
  }

  /**
   * URL of an image of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getImageLink() {
    return imageLink;
  }

  /**
   * URL of an image of the item.
   * @param imageLink imageLink or {@code null} for none
   */
  public Product setImageLink(java.lang.String imageLink) {
    this.imageLink = imageLink;
    return this;
  }

  /**
   * The list of destinations to include for this target (corresponds to checked check boxes in
   * Merchant Center). Default destinations are always included unless provided in
   * `excludedDestinations`.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getIncludedDestinations() {
    return includedDestinations;
  }

  /**
   * The list of destinations to include for this target (corresponds to checked check boxes in
   * Merchant Center). Default destinations are always included unless provided in
   * `excludedDestinations`.
   * @param includedDestinations includedDestinations or {@code null} for none
   */
  public Product setIncludedDestinations(java.util.List<java.lang.String> includedDestinations) {
    this.includedDestinations = includedDestinations;
    return this;
  }

  /**
   * Number and amount of installments to pay for an item.
   * @return value or {@code null} for none
   */
  public Installment getInstallment() {
    return installment;
  }

  /**
   * Number and amount of installments to pay for an item.
   * @param installment installment or {@code null} for none
   */
  public Product setInstallment(Installment installment) {
    this.installment = installment;
    return this;
  }

  /**
   * Whether the item is a merchant-defined bundle. A bundle is a custom grouping of different
   * products sold by a merchant for a single price.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsBundle() {
    return isBundle;
  }

  /**
   * Whether the item is a merchant-defined bundle. A bundle is a custom grouping of different
   * products sold by a merchant for a single price.
   * @param isBundle isBundle or {@code null} for none
   */
  public Product setIsBundle(java.lang.Boolean isBundle) {
    this.isBundle = isBundle;
    return this;
  }

  /**
   * Shared identifier for all variants of the same product.
   * @return value or {@code null} for none
   */
  public java.lang.String getItemGroupId() {
    return itemGroupId;
  }

  /**
   * Shared identifier for all variants of the same product.
   * @param itemGroupId itemGroupId or {@code null} for none
   */
  public Product setItemGroupId(java.lang.String itemGroupId) {
    this.itemGroupId = itemGroupId;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#product`"
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#product`"
   * @param kind kind or {@code null} for none
   */
  public Product setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Additional URLs of lifestyle images of the item. Used to explicitly identify images that
   * showcase your item in a real-world context. See the Help Center article for more information.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLifestyleImageLinks() {
    return lifestyleImageLinks;
  }

  /**
   * Additional URLs of lifestyle images of the item. Used to explicitly identify images that
   * showcase your item in a real-world context. See the Help Center article for more information.
   * @param lifestyleImageLinks lifestyleImageLinks or {@code null} for none
   */
  public Product setLifestyleImageLinks(java.util.List<java.lang.String> lifestyleImageLinks) {
    this.lifestyleImageLinks = lifestyleImageLinks;
    return this;
  }

  /**
   * URL directly linking to your item's page on your website.
   * @return value or {@code null} for none
   */
  public java.lang.String getLink() {
    return link;
  }

  /**
   * URL directly linking to your item's page on your website.
   * @param link link or {@code null} for none
   */
  public Product setLink(java.lang.String link) {
    this.link = link;
    return this;
  }

  /**
   * URL template for merchant hosted local storefront.
   * @return value or {@code null} for none
   */
  public java.lang.String getLinkTemplate() {
    return linkTemplate;
  }

  /**
   * URL template for merchant hosted local storefront.
   * @param linkTemplate linkTemplate or {@code null} for none
   */
  public Product setLinkTemplate(java.lang.String linkTemplate) {
    this.linkTemplate = linkTemplate;
    return this;
  }

  /**
   * Loyalty points that users receive after purchasing the item. Japan only.
   * @return value or {@code null} for none
   */
  public LoyaltyPoints getLoyaltyPoints() {
    return loyaltyPoints;
  }

  /**
   * Loyalty points that users receive after purchasing the item. Japan only.
   * @param loyaltyPoints loyaltyPoints or {@code null} for none
   */
  public Product setLoyaltyPoints(LoyaltyPoints loyaltyPoints) {
    this.loyaltyPoints = loyaltyPoints;
    return this;
  }

  /**
   * The material of which the item is made.
   * @return value or {@code null} for none
   */
  public java.lang.String getMaterial() {
    return material;
  }

  /**
   * The material of which the item is made.
   * @param material material or {@code null} for none
   */
  public Product setMaterial(java.lang.String material) {
    this.material = material;
    return this;
  }

  /**
   * The energy efficiency class as defined in EU directive 2010/30/EU.
   * @return value or {@code null} for none
   */
  public java.lang.String getMaxEnergyEfficiencyClass() {
    return maxEnergyEfficiencyClass;
  }

  /**
   * The energy efficiency class as defined in EU directive 2010/30/EU.
   * @param maxEnergyEfficiencyClass maxEnergyEfficiencyClass or {@code null} for none
   */
  public Product setMaxEnergyEfficiencyClass(java.lang.String maxEnergyEfficiencyClass) {
    this.maxEnergyEfficiencyClass = maxEnergyEfficiencyClass;
    return this;
  }

  /**
   * Maximal product handling time (in business days).
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxHandlingTime() {
    return maxHandlingTime;
  }

  /**
   * Maximal product handling time (in business days).
   * @param maxHandlingTime maxHandlingTime or {@code null} for none
   */
  public Product setMaxHandlingTime(java.lang.Long maxHandlingTime) {
    this.maxHandlingTime = maxHandlingTime;
    return this;
  }

  /**
   * The energy efficiency class as defined in EU directive 2010/30/EU.
   * @return value or {@code null} for none
   */
  public java.lang.String getMinEnergyEfficiencyClass() {
    return minEnergyEfficiencyClass;
  }

  /**
   * The energy efficiency class as defined in EU directive 2010/30/EU.
   * @param minEnergyEfficiencyClass minEnergyEfficiencyClass or {@code null} for none
   */
  public Product setMinEnergyEfficiencyClass(java.lang.String minEnergyEfficiencyClass) {
    this.minEnergyEfficiencyClass = minEnergyEfficiencyClass;
    return this;
  }

  /**
   * Minimal product handling time (in business days).
   * @return value or {@code null} for none
   */
  public java.lang.Long getMinHandlingTime() {
    return minHandlingTime;
  }

  /**
   * Minimal product handling time (in business days).
   * @param minHandlingTime minHandlingTime or {@code null} for none
   */
  public Product setMinHandlingTime(java.lang.Long minHandlingTime) {
    this.minHandlingTime = minHandlingTime;
    return this;
  }

  /**
   * URL for the mobile-optimized version of your item's landing page.
   * @return value or {@code null} for none
   */
  public java.lang.String getMobileLink() {
    return mobileLink;
  }

  /**
   * URL for the mobile-optimized version of your item's landing page.
   * @param mobileLink mobileLink or {@code null} for none
   */
  public Product setMobileLink(java.lang.String mobileLink) {
    this.mobileLink = mobileLink;
    return this;
  }

  /**
   * URL template for merchant hosted local storefront optimized for mobile devices.
   * @return value or {@code null} for none
   */
  public java.lang.String getMobileLinkTemplate() {
    return mobileLinkTemplate;
  }

  /**
   * URL template for merchant hosted local storefront optimized for mobile devices.
   * @param mobileLinkTemplate mobileLinkTemplate or {@code null} for none
   */
  public Product setMobileLinkTemplate(java.lang.String mobileLinkTemplate) {
    this.mobileLinkTemplate = mobileLinkTemplate;
    return this;
  }

  /**
   * Manufacturer Part Number (MPN) of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getMpn() {
    return mpn;
  }

  /**
   * Manufacturer Part Number (MPN) of the item.
   * @param mpn mpn or {@code null} for none
   */
  public Product setMpn(java.lang.String mpn) {
    this.mpn = mpn;
    return this;
  }

  /**
   * The number of identical products in a merchant-defined multipack.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMultipack() {
    return multipack;
  }

  /**
   * The number of identical products in a merchant-defined multipack.
   * @param multipack multipack or {@code null} for none
   */
  public Product setMultipack(java.lang.Long multipack) {
    this.multipack = multipack;
    return this;
  }

  /**
   * Required. A unique identifier for the item. Leading and trailing whitespaces are stripped and
   * multiple whitespaces are replaced by a single whitespace upon submission. Only valid unicode
   * characters are accepted. See the products feed specification for details. *Note:* Content API
   * methods that operate on products take the REST ID of the product, *not* this identifier.
   * @return value or {@code null} for none
   */
  public java.lang.String getOfferId() {
    return offerId;
  }

  /**
   * Required. A unique identifier for the item. Leading and trailing whitespaces are stripped and
   * multiple whitespaces are replaced by a single whitespace upon submission. Only valid unicode
   * characters are accepted. See the products feed specification for details. *Note:* Content API
   * methods that operate on products take the REST ID of the product, *not* this identifier.
   * @param offerId offerId or {@code null} for none
   */
  public Product setOfferId(java.lang.String offerId) {
    this.offerId = offerId;
    return this;
  }

  /**
   * The item's pattern (for example, polka dots).
   * @return value or {@code null} for none
   */
  public java.lang.String getPattern() {
    return pattern;
  }

  /**
   * The item's pattern (for example, polka dots).
   * @param pattern pattern or {@code null} for none
   */
  public Product setPattern(java.lang.String pattern) {
    this.pattern = pattern;
    return this;
  }

  /**
   * Publication of this item should be temporarily paused. Acceptable values are: - "`ads`"
   * @return value or {@code null} for none
   */
  public java.lang.String getPause() {
    return pause;
  }

  /**
   * Publication of this item should be temporarily paused. Acceptable values are: - "`ads`"
   * @param pause pause or {@code null} for none
   */
  public Product setPause(java.lang.String pause) {
    this.pause = pause;
    return this;
  }

  /**
   * The pick up option for the item. Acceptable values are: - "`buy`" - "`reserve`" - "`ship to
   * store`" - "`not supported`"
   * @return value or {@code null} for none
   */
  public java.lang.String getPickupMethod() {
    return pickupMethod;
  }

  /**
   * The pick up option for the item. Acceptable values are: - "`buy`" - "`reserve`" - "`ship to
   * store`" - "`not supported`"
   * @param pickupMethod pickupMethod or {@code null} for none
   */
  public Product setPickupMethod(java.lang.String pickupMethod) {
    this.pickupMethod = pickupMethod;
    return this;
  }

  /**
   * Item store pickup timeline. Acceptable values are: - "`same day`" - "`next day`" - "`2-day`" -
   * "`3-day`" - "`4-day`" - "`5-day`" - "`6-day`" - "`7-day`" - "`multi-week`"
   * @return value or {@code null} for none
   */
  public java.lang.String getPickupSla() {
    return pickupSla;
  }

  /**
   * Item store pickup timeline. Acceptable values are: - "`same day`" - "`next day`" - "`2-day`" -
   * "`3-day`" - "`4-day`" - "`5-day`" - "`6-day`" - "`7-day`" - "`multi-week`"
   * @param pickupSla pickupSla or {@code null} for none
   */
  public Product setPickupSla(java.lang.String pickupSla) {
    this.pickupSla = pickupSla;
    return this;
  }

  /**
   * Price of the item.
   * @return value or {@code null} for none
   */
  public Price getPrice() {
    return price;
  }

  /**
   * Price of the item.
   * @param price price or {@code null} for none
   */
  public Product setPrice(Price price) {
    this.price = price;
    return this;
  }

  /**
   * Technical specification or additional product details.
   * @return value or {@code null} for none
   */
  public java.util.List<ProductProductDetail> getProductDetails() {
    return productDetails;
  }

  /**
   * Technical specification or additional product details.
   * @param productDetails productDetails or {@code null} for none
   */
  public Product setProductDetails(java.util.List<ProductProductDetail> productDetails) {
    this.productDetails = productDetails;
    return this;
  }

  /**
   * The height of the product in the units provided. The value must be between 0 (exclusive) and
   * 3000 (inclusive).
   * @return value or {@code null} for none
   */
  public ProductDimension getProductHeight() {
    return productHeight;
  }

  /**
   * The height of the product in the units provided. The value must be between 0 (exclusive) and
   * 3000 (inclusive).
   * @param productHeight productHeight or {@code null} for none
   */
  public Product setProductHeight(ProductDimension productHeight) {
    this.productHeight = productHeight;
    return this;
  }

  /**
   * Bullet points describing the most relevant highlights of a product.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getProductHighlights() {
    return productHighlights;
  }

  /**
   * Bullet points describing the most relevant highlights of a product.
   * @param productHighlights productHighlights or {@code null} for none
   */
  public Product setProductHighlights(java.util.List<java.lang.String> productHighlights) {
    this.productHighlights = productHighlights;
    return this;
  }

  /**
   * The length of the product in the units provided. The value must be between 0 (exclusive) and
   * 3000 (inclusive).
   * @return value or {@code null} for none
   */
  public ProductDimension getProductLength() {
    return productLength;
  }

  /**
   * The length of the product in the units provided. The value must be between 0 (exclusive) and
   * 3000 (inclusive).
   * @param productLength productLength or {@code null} for none
   */
  public Product setProductLength(ProductDimension productLength) {
    this.productLength = productLength;
    return this;
  }

  /**
   * Categories of the item (formatted as in product data specification).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getProductTypes() {
    return productTypes;
  }

  /**
   * Categories of the item (formatted as in product data specification).
   * @param productTypes productTypes or {@code null} for none
   */
  public Product setProductTypes(java.util.List<java.lang.String> productTypes) {
    this.productTypes = productTypes;
    return this;
  }

  /**
   * The weight of the product in the units provided. The value must be between 0 (exclusive) and
   * 2000 (inclusive).
   * @return value or {@code null} for none
   */
  public ProductWeight getProductWeight() {
    return productWeight;
  }

  /**
   * The weight of the product in the units provided. The value must be between 0 (exclusive) and
   * 2000 (inclusive).
   * @param productWeight productWeight or {@code null} for none
   */
  public Product setProductWeight(ProductWeight productWeight) {
    this.productWeight = productWeight;
    return this;
  }

  /**
   * The width of the product in the units provided. The value must be between 0 (exclusive) and
   * 3000 (inclusive).
   * @return value or {@code null} for none
   */
  public ProductDimension getProductWidth() {
    return productWidth;
  }

  /**
   * The width of the product in the units provided. The value must be between 0 (exclusive) and
   * 3000 (inclusive).
   * @param productWidth productWidth or {@code null} for none
   */
  public Product setProductWidth(ProductDimension productWidth) {
    this.productWidth = productWidth;
    return this;
  }

  /**
   * The unique ID of a promotion.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPromotionIds() {
    return promotionIds;
  }

  /**
   * The unique ID of a promotion.
   * @param promotionIds promotionIds or {@code null} for none
   */
  public Product setPromotionIds(java.util.List<java.lang.String> promotionIds) {
    this.promotionIds = promotionIds;
    return this;
  }

  /**
   * Advertised sale price of the item.
   * @return value or {@code null} for none
   */
  public Price getSalePrice() {
    return salePrice;
  }

  /**
   * Advertised sale price of the item.
   * @param salePrice salePrice or {@code null} for none
   */
  public Product setSalePrice(Price salePrice) {
    this.salePrice = salePrice;
    return this;
  }

  /**
   * Date range during which the item is on sale (see product data specification ).
   * @return value or {@code null} for none
   */
  public java.lang.String getSalePriceEffectiveDate() {
    return salePriceEffectiveDate;
  }

  /**
   * Date range during which the item is on sale (see product data specification ).
   * @param salePriceEffectiveDate salePriceEffectiveDate or {@code null} for none
   */
  public Product setSalePriceEffectiveDate(java.lang.String salePriceEffectiveDate) {
    this.salePriceEffectiveDate = salePriceEffectiveDate;
    return this;
  }

  /**
   * The quantity of the product that is available for selling on Google. Supported only for online
   * products.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSellOnGoogleQuantity() {
    return sellOnGoogleQuantity;
  }

  /**
   * The quantity of the product that is available for selling on Google. Supported only for online
   * products.
   * @param sellOnGoogleQuantity sellOnGoogleQuantity or {@code null} for none
   */
  public Product setSellOnGoogleQuantity(java.lang.Long sellOnGoogleQuantity) {
    this.sellOnGoogleQuantity = sellOnGoogleQuantity;
    return this;
  }

  /**
   * Shipping rules.
   * @return value or {@code null} for none
   */
  public java.util.List<ProductShipping> getShipping() {
    return shipping;
  }

  /**
   * Shipping rules.
   * @param shipping shipping or {@code null} for none
   */
  public Product setShipping(java.util.List<ProductShipping> shipping) {
    this.shipping = shipping;
    return this;
  }

  /**
   * Height of the item for shipping.
   * @return value or {@code null} for none
   */
  public ProductShippingDimension getShippingHeight() {
    return shippingHeight;
  }

  /**
   * Height of the item for shipping.
   * @param shippingHeight shippingHeight or {@code null} for none
   */
  public Product setShippingHeight(ProductShippingDimension shippingHeight) {
    this.shippingHeight = shippingHeight;
    return this;
  }

  /**
   * The shipping label of the product, used to group product in account-level shipping rules.
   * @return value or {@code null} for none
   */
  public java.lang.String getShippingLabel() {
    return shippingLabel;
  }

  /**
   * The shipping label of the product, used to group product in account-level shipping rules.
   * @param shippingLabel shippingLabel or {@code null} for none
   */
  public Product setShippingLabel(java.lang.String shippingLabel) {
    this.shippingLabel = shippingLabel;
    return this;
  }

  /**
   * Length of the item for shipping.
   * @return value or {@code null} for none
   */
  public ProductShippingDimension getShippingLength() {
    return shippingLength;
  }

  /**
   * Length of the item for shipping.
   * @param shippingLength shippingLength or {@code null} for none
   */
  public Product setShippingLength(ProductShippingDimension shippingLength) {
    this.shippingLength = shippingLength;
    return this;
  }

  /**
   * Weight of the item for shipping.
   * @return value or {@code null} for none
   */
  public ProductShippingWeight getShippingWeight() {
    return shippingWeight;
  }

  /**
   * Weight of the item for shipping.
   * @param shippingWeight shippingWeight or {@code null} for none
   */
  public Product setShippingWeight(ProductShippingWeight shippingWeight) {
    this.shippingWeight = shippingWeight;
    return this;
  }

  /**
   * Width of the item for shipping.
   * @return value or {@code null} for none
   */
  public ProductShippingDimension getShippingWidth() {
    return shippingWidth;
  }

  /**
   * Width of the item for shipping.
   * @param shippingWidth shippingWidth or {@code null} for none
   */
  public Product setShippingWidth(ProductShippingDimension shippingWidth) {
    this.shippingWidth = shippingWidth;
    return this;
  }

  /**
   * List of country codes (ISO 3166-1 alpha-2) to exclude the offer from Shopping Ads destination.
   * Countries from this list are removed from countries configured in MC feed settings.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getShoppingAdsExcludedCountries() {
    return shoppingAdsExcludedCountries;
  }

  /**
   * List of country codes (ISO 3166-1 alpha-2) to exclude the offer from Shopping Ads destination.
   * Countries from this list are removed from countries configured in MC feed settings.
   * @param shoppingAdsExcludedCountries shoppingAdsExcludedCountries or {@code null} for none
   */
  public Product setShoppingAdsExcludedCountries(java.util.List<java.lang.String> shoppingAdsExcludedCountries) {
    this.shoppingAdsExcludedCountries = shoppingAdsExcludedCountries;
    return this;
  }

  /**
   * System in which the size is specified. Recommended for apparel items.
   * @return value or {@code null} for none
   */
  public java.lang.String getSizeSystem() {
    return sizeSystem;
  }

  /**
   * System in which the size is specified. Recommended for apparel items.
   * @param sizeSystem sizeSystem or {@code null} for none
   */
  public Product setSizeSystem(java.lang.String sizeSystem) {
    this.sizeSystem = sizeSystem;
    return this;
  }

  /**
   * The cut of the item. Recommended for apparel items.
   * @return value or {@code null} for none
   */
  public java.lang.String getSizeType() {
    return sizeType;
  }

  /**
   * The cut of the item. Recommended for apparel items.
   * @param sizeType sizeType or {@code null} for none
   */
  public Product setSizeType(java.lang.String sizeType) {
    this.sizeType = sizeType;
    return this;
  }

  /**
   * Size of the item. Only one value is allowed. For variants with different sizes, insert a
   * separate product for each size with the same `itemGroupId` value (see size definition).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSizes() {
    return sizes;
  }

  /**
   * Size of the item. Only one value is allowed. For variants with different sizes, insert a
   * separate product for each size with the same `itemGroupId` value (see size definition).
   * @param sizes sizes or {@code null} for none
   */
  public Product setSizes(java.util.List<java.lang.String> sizes) {
    this.sizes = sizes;
    return this;
  }

  /**
   * The source of the offer, that is, how the offer was created. Acceptable values are: - "`api`" -
   * "`crawl`" - "`feed`"
   * @return value or {@code null} for none
   */
  public java.lang.String getSource() {
    return source;
  }

  /**
   * The source of the offer, that is, how the offer was created. Acceptable values are: - "`api`" -
   * "`crawl`" - "`feed`"
   * @param source source or {@code null} for none
   */
  public Product setSource(java.lang.String source) {
    this.source = source;
    return this;
  }

  /**
   * Number of periods (months or years) and amount of payment per period for an item with an
   * associated subscription contract.
   * @return value or {@code null} for none
   */
  public ProductSubscriptionCost getSubscriptionCost() {
    return subscriptionCost;
  }

  /**
   * Number of periods (months or years) and amount of payment per period for an item with an
   * associated subscription contract.
   * @param subscriptionCost subscriptionCost or {@code null} for none
   */
  public Product setSubscriptionCost(ProductSubscriptionCost subscriptionCost) {
    this.subscriptionCost = subscriptionCost;
    return this;
  }

  /**
   * Required. The CLDR territory code for the item's country of sale.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetCountry() {
    return targetCountry;
  }

  /**
   * Required. The CLDR territory code for the item's country of sale.
   * @param targetCountry targetCountry or {@code null} for none
   */
  public Product setTargetCountry(java.lang.String targetCountry) {
    this.targetCountry = targetCountry;
    return this;
  }

  /**
   * The tax category of the product, used to configure detailed tax nexus in account-level tax
   * settings.
   * @return value or {@code null} for none
   */
  public java.lang.String getTaxCategory() {
    return taxCategory;
  }

  /**
   * The tax category of the product, used to configure detailed tax nexus in account-level tax
   * settings.
   * @param taxCategory taxCategory or {@code null} for none
   */
  public Product setTaxCategory(java.lang.String taxCategory) {
    this.taxCategory = taxCategory;
    return this;
  }

  /**
   * Tax information.
   * @return value or {@code null} for none
   */
  public java.util.List<ProductTax> getTaxes() {
    return taxes;
  }

  /**
   * Tax information.
   * @param taxes taxes or {@code null} for none
   */
  public Product setTaxes(java.util.List<ProductTax> taxes) {
    this.taxes = taxes;
    return this;
  }

  /**
   * Title of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Title of the item.
   * @param title title or {@code null} for none
   */
  public Product setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * The transit time label of the product, used to group product in account-level transit time
   * tables.
   * @return value or {@code null} for none
   */
  public java.lang.String getTransitTimeLabel() {
    return transitTimeLabel;
  }

  /**
   * The transit time label of the product, used to group product in account-level transit time
   * tables.
   * @param transitTimeLabel transitTimeLabel or {@code null} for none
   */
  public Product setTransitTimeLabel(java.lang.String transitTimeLabel) {
    this.transitTimeLabel = transitTimeLabel;
    return this;
  }

  /**
   * The preference of the denominator of the unit price.
   * @return value or {@code null} for none
   */
  public ProductUnitPricingBaseMeasure getUnitPricingBaseMeasure() {
    return unitPricingBaseMeasure;
  }

  /**
   * The preference of the denominator of the unit price.
   * @param unitPricingBaseMeasure unitPricingBaseMeasure or {@code null} for none
   */
  public Product setUnitPricingBaseMeasure(ProductUnitPricingBaseMeasure unitPricingBaseMeasure) {
    this.unitPricingBaseMeasure = unitPricingBaseMeasure;
    return this;
  }

  /**
   * The measure and dimension of an item.
   * @return value or {@code null} for none
   */
  public ProductUnitPricingMeasure getUnitPricingMeasure() {
    return unitPricingMeasure;
  }

  /**
   * The measure and dimension of an item.
   * @param unitPricingMeasure unitPricingMeasure or {@code null} for none
   */
  public Product setUnitPricingMeasure(ProductUnitPricingMeasure unitPricingMeasure) {
    this.unitPricingMeasure = unitPricingMeasure;
    return this;
  }

  /**
   * URL of the 3D model of the item to provide more visuals.
   * @return value or {@code null} for none
   */
  public java.lang.String getVirtualModelLink() {
    return virtualModelLink;
  }

  /**
   * URL of the 3D model of the item to provide more visuals.
   * @param virtualModelLink virtualModelLink or {@code null} for none
   */
  public Product setVirtualModelLink(java.lang.String virtualModelLink) {
    this.virtualModelLink = virtualModelLink;
    return this;
  }

  @Override
  public Product set(String fieldName, Object value) {
    return (Product) super.set(fieldName, value);
  }

  @Override
  public Product clone() {
    return (Product) super.clone();
  }

}
