/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Product cluster fields. A product cluster is a grouping for different offers that represent the
 * same product. Values are only set for fields requested explicitly in the request's search query.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProductCluster extends com.google.api.client.json.GenericJson {

  /**
   * Brand of the product cluster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String brand;

  /**
   * Tells if there is at least one product of the brand currently `IN_STOCK` in your product feed
   * across multiple countries, all products are `OUT_OF_STOCK` in your product feed, or
   * `NOT_IN_INVENTORY`. The field doesn't take the Best Sellers report country filter into account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String brandInventoryStatus;

  /**
   * Product category (1st level) of the product cluster, represented in Google's product taxonomy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String categoryL1;

  /**
   * Product category (2nd level) of the product cluster, represented in Google's product taxonomy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String categoryL2;

  /**
   * Product category (3rd level) of the product cluster, represented in Google's product taxonomy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String categoryL3;

  /**
   * Product category (4th level) of the product cluster, represented in Google's product taxonomy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String categoryL4;

  /**
   * Product category (5th level) of the product cluster, represented in Google's product taxonomy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String categoryL5;

  /**
   * Tells whether the product cluster is `IN_STOCK` in your product feed across multiple countries,
   * `OUT_OF_STOCK` in your product feed, or `NOT_IN_INVENTORY` at all. The field doesn't take the
   * Best Sellers report country filter into account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String inventoryStatus;

  /**
   * Title of the product cluster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * GTINs of example variants of the product cluster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> variantGtins;

  /**
   * Brand of the product cluster.
   * @return value or {@code null} for none
   */
  public java.lang.String getBrand() {
    return brand;
  }

  /**
   * Brand of the product cluster.
   * @param brand brand or {@code null} for none
   */
  public ProductCluster setBrand(java.lang.String brand) {
    this.brand = brand;
    return this;
  }

  /**
   * Tells if there is at least one product of the brand currently `IN_STOCK` in your product feed
   * across multiple countries, all products are `OUT_OF_STOCK` in your product feed, or
   * `NOT_IN_INVENTORY`. The field doesn't take the Best Sellers report country filter into account.
   * @return value or {@code null} for none
   */
  public java.lang.String getBrandInventoryStatus() {
    return brandInventoryStatus;
  }

  /**
   * Tells if there is at least one product of the brand currently `IN_STOCK` in your product feed
   * across multiple countries, all products are `OUT_OF_STOCK` in your product feed, or
   * `NOT_IN_INVENTORY`. The field doesn't take the Best Sellers report country filter into account.
   * @param brandInventoryStatus brandInventoryStatus or {@code null} for none
   */
  public ProductCluster setBrandInventoryStatus(java.lang.String brandInventoryStatus) {
    this.brandInventoryStatus = brandInventoryStatus;
    return this;
  }

  /**
   * Product category (1st level) of the product cluster, represented in Google's product taxonomy.
   * @return value or {@code null} for none
   */
  public java.lang.String getCategoryL1() {
    return categoryL1;
  }

  /**
   * Product category (1st level) of the product cluster, represented in Google's product taxonomy.
   * @param categoryL1 categoryL1 or {@code null} for none
   */
  public ProductCluster setCategoryL1(java.lang.String categoryL1) {
    this.categoryL1 = categoryL1;
    return this;
  }

  /**
   * Product category (2nd level) of the product cluster, represented in Google's product taxonomy.
   * @return value or {@code null} for none
   */
  public java.lang.String getCategoryL2() {
    return categoryL2;
  }

  /**
   * Product category (2nd level) of the product cluster, represented in Google's product taxonomy.
   * @param categoryL2 categoryL2 or {@code null} for none
   */
  public ProductCluster setCategoryL2(java.lang.String categoryL2) {
    this.categoryL2 = categoryL2;
    return this;
  }

  /**
   * Product category (3rd level) of the product cluster, represented in Google's product taxonomy.
   * @return value or {@code null} for none
   */
  public java.lang.String getCategoryL3() {
    return categoryL3;
  }

  /**
   * Product category (3rd level) of the product cluster, represented in Google's product taxonomy.
   * @param categoryL3 categoryL3 or {@code null} for none
   */
  public ProductCluster setCategoryL3(java.lang.String categoryL3) {
    this.categoryL3 = categoryL3;
    return this;
  }

  /**
   * Product category (4th level) of the product cluster, represented in Google's product taxonomy.
   * @return value or {@code null} for none
   */
  public java.lang.String getCategoryL4() {
    return categoryL4;
  }

  /**
   * Product category (4th level) of the product cluster, represented in Google's product taxonomy.
   * @param categoryL4 categoryL4 or {@code null} for none
   */
  public ProductCluster setCategoryL4(java.lang.String categoryL4) {
    this.categoryL4 = categoryL4;
    return this;
  }

  /**
   * Product category (5th level) of the product cluster, represented in Google's product taxonomy.
   * @return value or {@code null} for none
   */
  public java.lang.String getCategoryL5() {
    return categoryL5;
  }

  /**
   * Product category (5th level) of the product cluster, represented in Google's product taxonomy.
   * @param categoryL5 categoryL5 or {@code null} for none
   */
  public ProductCluster setCategoryL5(java.lang.String categoryL5) {
    this.categoryL5 = categoryL5;
    return this;
  }

  /**
   * Tells whether the product cluster is `IN_STOCK` in your product feed across multiple countries,
   * `OUT_OF_STOCK` in your product feed, or `NOT_IN_INVENTORY` at all. The field doesn't take the
   * Best Sellers report country filter into account.
   * @return value or {@code null} for none
   */
  public java.lang.String getInventoryStatus() {
    return inventoryStatus;
  }

  /**
   * Tells whether the product cluster is `IN_STOCK` in your product feed across multiple countries,
   * `OUT_OF_STOCK` in your product feed, or `NOT_IN_INVENTORY` at all. The field doesn't take the
   * Best Sellers report country filter into account.
   * @param inventoryStatus inventoryStatus or {@code null} for none
   */
  public ProductCluster setInventoryStatus(java.lang.String inventoryStatus) {
    this.inventoryStatus = inventoryStatus;
    return this;
  }

  /**
   * Title of the product cluster.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Title of the product cluster.
   * @param title title or {@code null} for none
   */
  public ProductCluster setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * GTINs of example variants of the product cluster.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getVariantGtins() {
    return variantGtins;
  }

  /**
   * GTINs of example variants of the product cluster.
   * @param variantGtins variantGtins or {@code null} for none
   */
  public ProductCluster setVariantGtins(java.util.List<java.lang.String> variantGtins) {
    this.variantGtins = variantGtins;
    return this;
  }

  @Override
  public ProductCluster set(String fieldName, Object value) {
    return (ProductCluster) super.set(fieldName, value);
  }

  @Override
  public ProductCluster clone() {
    return (ProductCluster) super.clone();
  }

}
