/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * An issue affecting specific product.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProductIssue extends com.google.api.client.json.GenericJson {

  /**
   * A list of actionable steps that can be executed to solve the issue. An example is requesting a
   * re-review or providing arguments when merchant disagrees with the issue. Actions that are
   * supported in (your) third-party application can be rendered as buttons and should be available
   * to merchant when they expand the issue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Action> actions;

  static {
    // hack to force ProGuard to consider Action used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Action.class);
  }

  /**
   * Clarifies the severity of the issue. The summarizing message, if present, should be shown right
   * under the title for each issue. It helps merchants to quickly understand the impact of the
   * issue. The detailed breakdown helps the merchant to fully understand the impact of the issue.
   * It can be rendered as dialog that opens when the merchant mouse over the summarized impact
   * statement. Issues with different severity can be styled differently. They may use a different
   * color or icon to signal the difference between `ERROR`, `WARNING` and `INFO`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProductIssueImpact impact;

  /**
   * Details of the issue as a pre-rendered HTML. HTML elements contain CSS classes that can be used
   * to customize the style of the content. Always sanitize the HTML before embedding it directly to
   * your application. The sanitizer needs to allow basic HTML tags, such as: `div`, `span`, `p`,
   * `a`, `ul`, `li`, `table`, `tr`, `td`. For example, you can use
   * [DOMPurify](https://www.npmjs.com/package/dompurify). CSS classes: * `issue-detail` - top level
   * container for the detail of the issue * `callout-banners` - section of the `issue-detail` with
   * callout banners * `callout-banner` - single callout banner, inside `callout-banners` *
   * `callout-banner-info` - callout with important information (default) * `callout-banner-warning`
   * - callout with a warning * `callout-banner-error` - callout informing about an error (most
   * severe) * `issue-content` - section of the `issue-detail`, contains multiple `content-element`
   * * `content-element` - content element such as a list, link or paragraph, inside `issue-content`
   * * `root-causes` - unordered list with items describing root causes of the issue, inside `issue-
   * content` * `root-causes-intro` - intro text before the `root-causes` list, inside `issue-
   * content` * `segment` - section of the text, `span` inside paragraph * `segment-attribute` -
   * section of the text that represents a product attribute, for example 'image\_link' * `segment-
   * literal` - section of the text that contains a special value, for example '0-1000 kg' *
   * `segment-bold` - section of the text that should be rendered as bold * `segment-italic` -
   * section of the text that should be rendered as italic * `tooltip` - used on paragraphs that
   * should be rendered with a tooltip. A section of the text in such a paragraph will have a class
   * `tooltip-text` and is intended to be shown in a mouse over dialog. If the style is not used,
   * the `tooltip-text` section would be shown on a new line, after the main part of the text. *
   * `tooltip-text` - marks a section of the text within a `tooltip`, that is intended to be shown
   * in a mouse over dialog. * `tooltip-icon` - marks a section of the text within a `tooltip`, that
   * can be replaced with a tooltip icon, for example '?' or 'i'. By default, this section contains
   * a `br` tag, that is separating the main text and the tooltip text when the style is not used. *
   * `tooltip-style-question` - the tooltip shows helpful information, can use the '?' as an icon. *
   * `tooltip-style-info` - the tooltip adds additional information fitting to the context, can use
   * the 'i' as an icon. * `content-moderation` - marks the paragraph that explains how the issue
   * was identified. * `new-element` - Present for new elements added to the pre-rendered content in
   * the future. To make sure that a new content element does not break your style, you can hide
   * everything with this class.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String prerenderedContent;

  /**
   * Title of the issue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * A list of actionable steps that can be executed to solve the issue. An example is requesting a
   * re-review or providing arguments when merchant disagrees with the issue. Actions that are
   * supported in (your) third-party application can be rendered as buttons and should be available
   * to merchant when they expand the issue.
   * @return value or {@code null} for none
   */
  public java.util.List<Action> getActions() {
    return actions;
  }

  /**
   * A list of actionable steps that can be executed to solve the issue. An example is requesting a
   * re-review or providing arguments when merchant disagrees with the issue. Actions that are
   * supported in (your) third-party application can be rendered as buttons and should be available
   * to merchant when they expand the issue.
   * @param actions actions or {@code null} for none
   */
  public ProductIssue setActions(java.util.List<Action> actions) {
    this.actions = actions;
    return this;
  }

  /**
   * Clarifies the severity of the issue. The summarizing message, if present, should be shown right
   * under the title for each issue. It helps merchants to quickly understand the impact of the
   * issue. The detailed breakdown helps the merchant to fully understand the impact of the issue.
   * It can be rendered as dialog that opens when the merchant mouse over the summarized impact
   * statement. Issues with different severity can be styled differently. They may use a different
   * color or icon to signal the difference between `ERROR`, `WARNING` and `INFO`.
   * @return value or {@code null} for none
   */
  public ProductIssueImpact getImpact() {
    return impact;
  }

  /**
   * Clarifies the severity of the issue. The summarizing message, if present, should be shown right
   * under the title for each issue. It helps merchants to quickly understand the impact of the
   * issue. The detailed breakdown helps the merchant to fully understand the impact of the issue.
   * It can be rendered as dialog that opens when the merchant mouse over the summarized impact
   * statement. Issues with different severity can be styled differently. They may use a different
   * color or icon to signal the difference between `ERROR`, `WARNING` and `INFO`.
   * @param impact impact or {@code null} for none
   */
  public ProductIssue setImpact(ProductIssueImpact impact) {
    this.impact = impact;
    return this;
  }

  /**
   * Details of the issue as a pre-rendered HTML. HTML elements contain CSS classes that can be used
   * to customize the style of the content. Always sanitize the HTML before embedding it directly to
   * your application. The sanitizer needs to allow basic HTML tags, such as: `div`, `span`, `p`,
   * `a`, `ul`, `li`, `table`, `tr`, `td`. For example, you can use
   * [DOMPurify](https://www.npmjs.com/package/dompurify). CSS classes: * `issue-detail` - top level
   * container for the detail of the issue * `callout-banners` - section of the `issue-detail` with
   * callout banners * `callout-banner` - single callout banner, inside `callout-banners` *
   * `callout-banner-info` - callout with important information (default) * `callout-banner-warning`
   * - callout with a warning * `callout-banner-error` - callout informing about an error (most
   * severe) * `issue-content` - section of the `issue-detail`, contains multiple `content-element`
   * * `content-element` - content element such as a list, link or paragraph, inside `issue-content`
   * * `root-causes` - unordered list with items describing root causes of the issue, inside `issue-
   * content` * `root-causes-intro` - intro text before the `root-causes` list, inside `issue-
   * content` * `segment` - section of the text, `span` inside paragraph * `segment-attribute` -
   * section of the text that represents a product attribute, for example 'image\_link' * `segment-
   * literal` - section of the text that contains a special value, for example '0-1000 kg' *
   * `segment-bold` - section of the text that should be rendered as bold * `segment-italic` -
   * section of the text that should be rendered as italic * `tooltip` - used on paragraphs that
   * should be rendered with a tooltip. A section of the text in such a paragraph will have a class
   * `tooltip-text` and is intended to be shown in a mouse over dialog. If the style is not used,
   * the `tooltip-text` section would be shown on a new line, after the main part of the text. *
   * `tooltip-text` - marks a section of the text within a `tooltip`, that is intended to be shown
   * in a mouse over dialog. * `tooltip-icon` - marks a section of the text within a `tooltip`, that
   * can be replaced with a tooltip icon, for example '?' or 'i'. By default, this section contains
   * a `br` tag, that is separating the main text and the tooltip text when the style is not used. *
   * `tooltip-style-question` - the tooltip shows helpful information, can use the '?' as an icon. *
   * `tooltip-style-info` - the tooltip adds additional information fitting to the context, can use
   * the 'i' as an icon. * `content-moderation` - marks the paragraph that explains how the issue
   * was identified. * `new-element` - Present for new elements added to the pre-rendered content in
   * the future. To make sure that a new content element does not break your style, you can hide
   * everything with this class.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrerenderedContent() {
    return prerenderedContent;
  }

  /**
   * Details of the issue as a pre-rendered HTML. HTML elements contain CSS classes that can be used
   * to customize the style of the content. Always sanitize the HTML before embedding it directly to
   * your application. The sanitizer needs to allow basic HTML tags, such as: `div`, `span`, `p`,
   * `a`, `ul`, `li`, `table`, `tr`, `td`. For example, you can use
   * [DOMPurify](https://www.npmjs.com/package/dompurify). CSS classes: * `issue-detail` - top level
   * container for the detail of the issue * `callout-banners` - section of the `issue-detail` with
   * callout banners * `callout-banner` - single callout banner, inside `callout-banners` *
   * `callout-banner-info` - callout with important information (default) * `callout-banner-warning`
   * - callout with a warning * `callout-banner-error` - callout informing about an error (most
   * severe) * `issue-content` - section of the `issue-detail`, contains multiple `content-element`
   * * `content-element` - content element such as a list, link or paragraph, inside `issue-content`
   * * `root-causes` - unordered list with items describing root causes of the issue, inside `issue-
   * content` * `root-causes-intro` - intro text before the `root-causes` list, inside `issue-
   * content` * `segment` - section of the text, `span` inside paragraph * `segment-attribute` -
   * section of the text that represents a product attribute, for example 'image\_link' * `segment-
   * literal` - section of the text that contains a special value, for example '0-1000 kg' *
   * `segment-bold` - section of the text that should be rendered as bold * `segment-italic` -
   * section of the text that should be rendered as italic * `tooltip` - used on paragraphs that
   * should be rendered with a tooltip. A section of the text in such a paragraph will have a class
   * `tooltip-text` and is intended to be shown in a mouse over dialog. If the style is not used,
   * the `tooltip-text` section would be shown on a new line, after the main part of the text. *
   * `tooltip-text` - marks a section of the text within a `tooltip`, that is intended to be shown
   * in a mouse over dialog. * `tooltip-icon` - marks a section of the text within a `tooltip`, that
   * can be replaced with a tooltip icon, for example '?' or 'i'. By default, this section contains
   * a `br` tag, that is separating the main text and the tooltip text when the style is not used. *
   * `tooltip-style-question` - the tooltip shows helpful information, can use the '?' as an icon. *
   * `tooltip-style-info` - the tooltip adds additional information fitting to the context, can use
   * the 'i' as an icon. * `content-moderation` - marks the paragraph that explains how the issue
   * was identified. * `new-element` - Present for new elements added to the pre-rendered content in
   * the future. To make sure that a new content element does not break your style, you can hide
   * everything with this class.
   * @param prerenderedContent prerenderedContent or {@code null} for none
   */
  public ProductIssue setPrerenderedContent(java.lang.String prerenderedContent) {
    this.prerenderedContent = prerenderedContent;
    return this;
  }

  /**
   * Title of the issue.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Title of the issue.
   * @param title title or {@code null} for none
   */
  public ProductIssue setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public ProductIssue set(String fieldName, Object value) {
    return (ProductIssue) super.set(fieldName, value);
  }

  @Override
  public ProductIssue clone() {
    return (ProductIssue) super.clone();
  }

}
