/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for ProductStatusDestinationStatus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProductStatusDestinationStatus extends com.google.api.client.json.GenericJson {

  /**
   * List of country codes (ISO 3166-1 alpha-2) where the offer is approved.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> approvedCountries;

  /**
   * The name of the destination
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destination;

  /**
   * List of country codes (ISO 3166-1 alpha-2) where the offer is disapproved.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> disapprovedCountries;

  /**
   * List of country codes (ISO 3166-1 alpha-2) where the offer is pending approval.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> pendingCountries;

  /**
   * Deprecated. Destination approval status in `targetCountry` of the offer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * List of country codes (ISO 3166-1 alpha-2) where the offer is approved.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getApprovedCountries() {
    return approvedCountries;
  }

  /**
   * List of country codes (ISO 3166-1 alpha-2) where the offer is approved.
   * @param approvedCountries approvedCountries or {@code null} for none
   */
  public ProductStatusDestinationStatus setApprovedCountries(java.util.List<java.lang.String> approvedCountries) {
    this.approvedCountries = approvedCountries;
    return this;
  }

  /**
   * The name of the destination
   * @return value or {@code null} for none
   */
  public java.lang.String getDestination() {
    return destination;
  }

  /**
   * The name of the destination
   * @param destination destination or {@code null} for none
   */
  public ProductStatusDestinationStatus setDestination(java.lang.String destination) {
    this.destination = destination;
    return this;
  }

  /**
   * List of country codes (ISO 3166-1 alpha-2) where the offer is disapproved.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDisapprovedCountries() {
    return disapprovedCountries;
  }

  /**
   * List of country codes (ISO 3166-1 alpha-2) where the offer is disapproved.
   * @param disapprovedCountries disapprovedCountries or {@code null} for none
   */
  public ProductStatusDestinationStatus setDisapprovedCountries(java.util.List<java.lang.String> disapprovedCountries) {
    this.disapprovedCountries = disapprovedCountries;
    return this;
  }

  /**
   * List of country codes (ISO 3166-1 alpha-2) where the offer is pending approval.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPendingCountries() {
    return pendingCountries;
  }

  /**
   * List of country codes (ISO 3166-1 alpha-2) where the offer is pending approval.
   * @param pendingCountries pendingCountries or {@code null} for none
   */
  public ProductStatusDestinationStatus setPendingCountries(java.util.List<java.lang.String> pendingCountries) {
    this.pendingCountries = pendingCountries;
    return this;
  }

  /**
   * Deprecated. Destination approval status in `targetCountry` of the offer.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Deprecated. Destination approval status in `targetCountry` of the offer.
   * @param status status or {@code null} for none
   */
  public ProductStatusDestinationStatus setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public ProductStatusDestinationStatus set(String fieldName, Object value) {
    return (ProductStatusDestinationStatus) super.set(fieldName, value);
  }

  @Override
  public ProductStatusDestinationStatus clone() {
    return (ProductStatusDestinationStatus) super.clone();
  }

}
