/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for ProductSubscriptionCost.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProductSubscriptionCost extends com.google.api.client.json.GenericJson {

  /**
   * The amount the buyer has to pay per subscription period.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price amount;

  /**
   * The type of subscription period.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String period;

  /**
   * The number of subscription periods the buyer has to pay.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long periodLength;

  /**
   * The amount the buyer has to pay per subscription period.
   * @return value or {@code null} for none
   */
  public Price getAmount() {
    return amount;
  }

  /**
   * The amount the buyer has to pay per subscription period.
   * @param amount amount or {@code null} for none
   */
  public ProductSubscriptionCost setAmount(Price amount) {
    this.amount = amount;
    return this;
  }

  /**
   * The type of subscription period.
   * @return value or {@code null} for none
   */
  public java.lang.String getPeriod() {
    return period;
  }

  /**
   * The type of subscription period.
   * @param period period or {@code null} for none
   */
  public ProductSubscriptionCost setPeriod(java.lang.String period) {
    this.period = period;
    return this;
  }

  /**
   * The number of subscription periods the buyer has to pay.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPeriodLength() {
    return periodLength;
  }

  /**
   * The number of subscription periods the buyer has to pay.
   * @param periodLength periodLength or {@code null} for none
   */
  public ProductSubscriptionCost setPeriodLength(java.lang.Long periodLength) {
    this.periodLength = periodLength;
    return this;
  }

  @Override
  public ProductSubscriptionCost set(String fieldName, Object value) {
    return (ProductSubscriptionCost) super.set(fieldName, value);
  }

  @Override
  public ProductSubscriptionCost clone() {
    return (ProductSubscriptionCost) super.clone();
  }

}
