/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Issue severity for all affected regions in a destination.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProductViewItemIssueIssueSeverityPerDestination extends com.google.api.client.json.GenericJson {

  /**
   * List of demoted countries in the destination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> demotedCountries;

  /**
   * Issue destination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destination;

  /**
   * List of disapproved countries in the destination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> disapprovedCountries;

  /**
   * List of demoted countries in the destination.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDemotedCountries() {
    return demotedCountries;
  }

  /**
   * List of demoted countries in the destination.
   * @param demotedCountries demotedCountries or {@code null} for none
   */
  public ProductViewItemIssueIssueSeverityPerDestination setDemotedCountries(java.util.List<java.lang.String> demotedCountries) {
    this.demotedCountries = demotedCountries;
    return this;
  }

  /**
   * Issue destination.
   * @return value or {@code null} for none
   */
  public java.lang.String getDestination() {
    return destination;
  }

  /**
   * Issue destination.
   * @param destination destination or {@code null} for none
   */
  public ProductViewItemIssueIssueSeverityPerDestination setDestination(java.lang.String destination) {
    this.destination = destination;
    return this;
  }

  /**
   * List of disapproved countries in the destination.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDisapprovedCountries() {
    return disapprovedCountries;
  }

  /**
   * List of disapproved countries in the destination.
   * @param disapprovedCountries disapprovedCountries or {@code null} for none
   */
  public ProductViewItemIssueIssueSeverityPerDestination setDisapprovedCountries(java.util.List<java.lang.String> disapprovedCountries) {
    this.disapprovedCountries = disapprovedCountries;
    return this;
  }

  @Override
  public ProductViewItemIssueIssueSeverityPerDestination set(String fieldName, Object value) {
    return (ProductViewItemIssueIssueSeverityPerDestination) super.set(fieldName, value);
  }

  @Override
  public ProductViewItemIssueIssueSeverityPerDestination clone() {
    return (ProductViewItemIssueIssueSeverityPerDestination) super.clone();
  }

}
