/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * A batch entry encoding a single non-batch products request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProductsCustomBatchRequestEntry extends com.google.api.client.json.GenericJson {

  /**
   * An entry ID, unique within the batch request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long batchId;

  /**
   * The Content API Supplemental Feed ID. If present then product insertion or deletion applies to
   * a supplemental feed instead of primary Content API feed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger feedId;

  /**
   * The ID of the managing account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger merchantId;

  /**
   * The method of the batch entry. Acceptable values are: - "`delete`" - "`get`" - "`insert`" -
   * "`update`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String method;

  /**
   * The product to insert or update. Only required if the method is `insert` or `update`. If the
   * `update` method is used with `updateMask` only to delete a field, then this isn't required. For
   * example, setting `salePrice` on the `updateMask` and not providing a `product` will result in
   * an existing sale price on the product specified by `productId` being deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Product product;

  /**
   * The ID of the product to get or mutate. Only defined if the method is `get`, `delete`, or
   * `update`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String productId;

  /**
   * The comma-separated list of product attributes to be updated. Example: `"title,salePrice"`.
   * Attributes specified in the update mask without a value specified in the body will be deleted
   * from the product. *You must specify the update mask to delete attributes.* Only top-level
   * product attributes can be updated. If not defined, product attributes with set values will be
   * updated and other attributes will stay unchanged. Only defined if the method is `update`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateMask;

  /**
   * An entry ID, unique within the batch request.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBatchId() {
    return batchId;
  }

  /**
   * An entry ID, unique within the batch request.
   * @param batchId batchId or {@code null} for none
   */
  public ProductsCustomBatchRequestEntry setBatchId(java.lang.Long batchId) {
    this.batchId = batchId;
    return this;
  }

  /**
   * The Content API Supplemental Feed ID. If present then product insertion or deletion applies to
   * a supplemental feed instead of primary Content API feed.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getFeedId() {
    return feedId;
  }

  /**
   * The Content API Supplemental Feed ID. If present then product insertion or deletion applies to
   * a supplemental feed instead of primary Content API feed.
   * @param feedId feedId or {@code null} for none
   */
  public ProductsCustomBatchRequestEntry setFeedId(java.math.BigInteger feedId) {
    this.feedId = feedId;
    return this;
  }

  /**
   * The ID of the managing account.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getMerchantId() {
    return merchantId;
  }

  /**
   * The ID of the managing account.
   * @param merchantId merchantId or {@code null} for none
   */
  public ProductsCustomBatchRequestEntry setMerchantId(java.math.BigInteger merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  /**
   * The method of the batch entry. Acceptable values are: - "`delete`" - "`get`" - "`insert`" -
   * "`update`"
   * @return value or {@code null} for none
   */
  public java.lang.String getMethod() {
    return method;
  }

  /**
   * The method of the batch entry. Acceptable values are: - "`delete`" - "`get`" - "`insert`" -
   * "`update`"
   * @param method method or {@code null} for none
   */
  public ProductsCustomBatchRequestEntry setMethod(java.lang.String method) {
    this.method = method;
    return this;
  }

  /**
   * The product to insert or update. Only required if the method is `insert` or `update`. If the
   * `update` method is used with `updateMask` only to delete a field, then this isn't required. For
   * example, setting `salePrice` on the `updateMask` and not providing a `product` will result in
   * an existing sale price on the product specified by `productId` being deleted.
   * @return value or {@code null} for none
   */
  public Product getProduct() {
    return product;
  }

  /**
   * The product to insert or update. Only required if the method is `insert` or `update`. If the
   * `update` method is used with `updateMask` only to delete a field, then this isn't required. For
   * example, setting `salePrice` on the `updateMask` and not providing a `product` will result in
   * an existing sale price on the product specified by `productId` being deleted.
   * @param product product or {@code null} for none
   */
  public ProductsCustomBatchRequestEntry setProduct(Product product) {
    this.product = product;
    return this;
  }

  /**
   * The ID of the product to get or mutate. Only defined if the method is `get`, `delete`, or
   * `update`.
   * @return value or {@code null} for none
   */
  public java.lang.String getProductId() {
    return productId;
  }

  /**
   * The ID of the product to get or mutate. Only defined if the method is `get`, `delete`, or
   * `update`.
   * @param productId productId or {@code null} for none
   */
  public ProductsCustomBatchRequestEntry setProductId(java.lang.String productId) {
    this.productId = productId;
    return this;
  }

  /**
   * The comma-separated list of product attributes to be updated. Example: `"title,salePrice"`.
   * Attributes specified in the update mask without a value specified in the body will be deleted
   * from the product. *You must specify the update mask to delete attributes.* Only top-level
   * product attributes can be updated. If not defined, product attributes with set values will be
   * updated and other attributes will stay unchanged. Only defined if the method is `update`.
   * @return value or {@code null} for none
   */
  public String getUpdateMask() {
    return updateMask;
  }

  /**
   * The comma-separated list of product attributes to be updated. Example: `"title,salePrice"`.
   * Attributes specified in the update mask without a value specified in the body will be deleted
   * from the product. *You must specify the update mask to delete attributes.* Only top-level
   * product attributes can be updated. If not defined, product attributes with set values will be
   * updated and other attributes will stay unchanged. Only defined if the method is `update`.
   * @param updateMask updateMask or {@code null} for none
   */
  public ProductsCustomBatchRequestEntry setUpdateMask(String updateMask) {
    this.updateMask = updateMask;
    return this;
  }

  @Override
  public ProductsCustomBatchRequestEntry set(String fieldName, Object value) {
    return (ProductsCustomBatchRequestEntry) super.set(fieldName, value);
  }

  @Override
  public ProductsCustomBatchRequestEntry clone() {
    return (ProductsCustomBatchRequestEntry) super.clone();
  }

}
