/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The status of the promotion.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PromotionPromotionStatus extends com.google.api.client.json.GenericJson {

  /**
   * Date on which the promotion has been created in [ISO
   * 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and offset, for example
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationDate;

  /**
   * The intended destinations for the promotion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PromotionPromotionStatusDestinationStatus> destinationStatuses;

  /**
   * Date on which the promotion status has been last updated in [ISO
   * 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and offset, for example
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lastUpdateDate;

  /**
   * A list of issues associated with the promotion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PromotionPromotionStatusPromotionIssue> promotionIssue;

  /**
   * Date on which the promotion has been created in [ISO
   * 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and offset, for example
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationDate() {
    return creationDate;
  }

  /**
   * Date on which the promotion has been created in [ISO
   * 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and offset, for example
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
   * @param creationDate creationDate or {@code null} for none
   */
  public PromotionPromotionStatus setCreationDate(java.lang.String creationDate) {
    this.creationDate = creationDate;
    return this;
  }

  /**
   * The intended destinations for the promotion.
   * @return value or {@code null} for none
   */
  public java.util.List<PromotionPromotionStatusDestinationStatus> getDestinationStatuses() {
    return destinationStatuses;
  }

  /**
   * The intended destinations for the promotion.
   * @param destinationStatuses destinationStatuses or {@code null} for none
   */
  public PromotionPromotionStatus setDestinationStatuses(java.util.List<PromotionPromotionStatusDestinationStatus> destinationStatuses) {
    this.destinationStatuses = destinationStatuses;
    return this;
  }

  /**
   * Date on which the promotion status has been last updated in [ISO
   * 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and offset, for example
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
   * @return value or {@code null} for none
   */
  public java.lang.String getLastUpdateDate() {
    return lastUpdateDate;
  }

  /**
   * Date on which the promotion status has been last updated in [ISO
   * 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and offset, for example
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
   * @param lastUpdateDate lastUpdateDate or {@code null} for none
   */
  public PromotionPromotionStatus setLastUpdateDate(java.lang.String lastUpdateDate) {
    this.lastUpdateDate = lastUpdateDate;
    return this;
  }

  /**
   * A list of issues associated with the promotion.
   * @return value or {@code null} for none
   */
  public java.util.List<PromotionPromotionStatusPromotionIssue> getPromotionIssue() {
    return promotionIssue;
  }

  /**
   * A list of issues associated with the promotion.
   * @param promotionIssue promotionIssue or {@code null} for none
   */
  public PromotionPromotionStatus setPromotionIssue(java.util.List<PromotionPromotionStatusPromotionIssue> promotionIssue) {
    this.promotionIssue = promotionIssue;
    return this;
  }

  @Override
  public PromotionPromotionStatus set(String fieldName, Object value) {
    return (PromotionPromotionStatus) super.set(fieldName, value);
  }

  @Override
  public PromotionPromotionStatus clone() {
    return (PromotionPromotionStatus) super.clone();
  }

}
