/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Recommendations are suggested ways to improve your merchant account's performance. For example,
 * to engage with a feature, or start using a new Google product.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Recommendation extends com.google.api.client.json.GenericJson {

  /**
   * Output only. CTAs of this recommendation. Repeated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RecommendationCallToAction> additionalCallToAction;

  /**
   * Output only. List of additional localized descriptions for a recommendation. Localication uses
   * the `languageCode` field in `GenerateRecommendations` requests. Not all description types are
   * guaranteed to be present and we recommend to rely on default description.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RecommendationDescription> additionalDescriptions;

  /**
   * Output only. Any creatives attached to the recommendation. Repeated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RecommendationCreative> creative;

  /**
   * Optional. Default CTA of the recommendation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RecommendationCallToAction defaultCallToAction;

  /**
   * Optional. Localized recommendation description. The localization the {@link
   * `GenerateRecommendationsRequest.language_code`} field in {@link
   * `GenerateRecommendationsRequest`} requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultDescription;

  /**
   * Optional. A numerical score of the impact from the recommendation's description. For example, a
   * recommendation might suggest an upward trend in sales for a certain product. Higher number
   * means larger impact.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer numericalImpact;

  /**
   * Optional. Indicates whether a user needs to pay when they complete the user journey suggested
   * by the recommendation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean paid;

  /**
   * Optional. Localized recommendation name. The localization uses the {@link
   * `GenerateRecommendationsRequest.language_code`} field in {@link
   * `GenerateRecommendationsRequest`} requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String recommendationName;

  /**
   * Optional. Subtype of the recommendations. Only applicable when multiple recommendations can be
   * generated per type, and is used as an identifier of recommendation under the same
   * recommendation type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subType;

  /**
   * Optional. Localized Recommendation Title. Localization uses the {@link
   * `GenerateRecommendationsRequest.language_code`} field in {@link
   * `GenerateRecommendationsRequest`} requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * Output only. Type of the recommendation. List of currently available recommendation types: -
   * OPPORTUNITY_CREATE_NEW_COLLECTION - OPPORTUNITY_CREATE_EMAIL_CAMPAIGN
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Output only. CTAs of this recommendation. Repeated.
   * @return value or {@code null} for none
   */
  public java.util.List<RecommendationCallToAction> getAdditionalCallToAction() {
    return additionalCallToAction;
  }

  /**
   * Output only. CTAs of this recommendation. Repeated.
   * @param additionalCallToAction additionalCallToAction or {@code null} for none
   */
  public Recommendation setAdditionalCallToAction(java.util.List<RecommendationCallToAction> additionalCallToAction) {
    this.additionalCallToAction = additionalCallToAction;
    return this;
  }

  /**
   * Output only. List of additional localized descriptions for a recommendation. Localication uses
   * the `languageCode` field in `GenerateRecommendations` requests. Not all description types are
   * guaranteed to be present and we recommend to rely on default description.
   * @return value or {@code null} for none
   */
  public java.util.List<RecommendationDescription> getAdditionalDescriptions() {
    return additionalDescriptions;
  }

  /**
   * Output only. List of additional localized descriptions for a recommendation. Localication uses
   * the `languageCode` field in `GenerateRecommendations` requests. Not all description types are
   * guaranteed to be present and we recommend to rely on default description.
   * @param additionalDescriptions additionalDescriptions or {@code null} for none
   */
  public Recommendation setAdditionalDescriptions(java.util.List<RecommendationDescription> additionalDescriptions) {
    this.additionalDescriptions = additionalDescriptions;
    return this;
  }

  /**
   * Output only. Any creatives attached to the recommendation. Repeated.
   * @return value or {@code null} for none
   */
  public java.util.List<RecommendationCreative> getCreative() {
    return creative;
  }

  /**
   * Output only. Any creatives attached to the recommendation. Repeated.
   * @param creative creative or {@code null} for none
   */
  public Recommendation setCreative(java.util.List<RecommendationCreative> creative) {
    this.creative = creative;
    return this;
  }

  /**
   * Optional. Default CTA of the recommendation.
   * @return value or {@code null} for none
   */
  public RecommendationCallToAction getDefaultCallToAction() {
    return defaultCallToAction;
  }

  /**
   * Optional. Default CTA of the recommendation.
   * @param defaultCallToAction defaultCallToAction or {@code null} for none
   */
  public Recommendation setDefaultCallToAction(RecommendationCallToAction defaultCallToAction) {
    this.defaultCallToAction = defaultCallToAction;
    return this;
  }

  /**
   * Optional. Localized recommendation description. The localization the {@link
   * `GenerateRecommendationsRequest.language_code`} field in {@link
   * `GenerateRecommendationsRequest`} requests.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultDescription() {
    return defaultDescription;
  }

  /**
   * Optional. Localized recommendation description. The localization the {@link
   * `GenerateRecommendationsRequest.language_code`} field in {@link
   * `GenerateRecommendationsRequest`} requests.
   * @param defaultDescription defaultDescription or {@code null} for none
   */
  public Recommendation setDefaultDescription(java.lang.String defaultDescription) {
    this.defaultDescription = defaultDescription;
    return this;
  }

  /**
   * Optional. A numerical score of the impact from the recommendation's description. For example, a
   * recommendation might suggest an upward trend in sales for a certain product. Higher number
   * means larger impact.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNumericalImpact() {
    return numericalImpact;
  }

  /**
   * Optional. A numerical score of the impact from the recommendation's description. For example, a
   * recommendation might suggest an upward trend in sales for a certain product. Higher number
   * means larger impact.
   * @param numericalImpact numericalImpact or {@code null} for none
   */
  public Recommendation setNumericalImpact(java.lang.Integer numericalImpact) {
    this.numericalImpact = numericalImpact;
    return this;
  }

  /**
   * Optional. Indicates whether a user needs to pay when they complete the user journey suggested
   * by the recommendation.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPaid() {
    return paid;
  }

  /**
   * Optional. Indicates whether a user needs to pay when they complete the user journey suggested
   * by the recommendation.
   * @param paid paid or {@code null} for none
   */
  public Recommendation setPaid(java.lang.Boolean paid) {
    this.paid = paid;
    return this;
  }

  /**
   * Optional. Localized recommendation name. The localization uses the {@link
   * `GenerateRecommendationsRequest.language_code`} field in {@link
   * `GenerateRecommendationsRequest`} requests.
   * @return value or {@code null} for none
   */
  public java.lang.String getRecommendationName() {
    return recommendationName;
  }

  /**
   * Optional. Localized recommendation name. The localization uses the {@link
   * `GenerateRecommendationsRequest.language_code`} field in {@link
   * `GenerateRecommendationsRequest`} requests.
   * @param recommendationName recommendationName or {@code null} for none
   */
  public Recommendation setRecommendationName(java.lang.String recommendationName) {
    this.recommendationName = recommendationName;
    return this;
  }

  /**
   * Optional. Subtype of the recommendations. Only applicable when multiple recommendations can be
   * generated per type, and is used as an identifier of recommendation under the same
   * recommendation type.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubType() {
    return subType;
  }

  /**
   * Optional. Subtype of the recommendations. Only applicable when multiple recommendations can be
   * generated per type, and is used as an identifier of recommendation under the same
   * recommendation type.
   * @param subType subType or {@code null} for none
   */
  public Recommendation setSubType(java.lang.String subType) {
    this.subType = subType;
    return this;
  }

  /**
   * Optional. Localized Recommendation Title. Localization uses the {@link
   * `GenerateRecommendationsRequest.language_code`} field in {@link
   * `GenerateRecommendationsRequest`} requests.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Optional. Localized Recommendation Title. Localization uses the {@link
   * `GenerateRecommendationsRequest.language_code`} field in {@link
   * `GenerateRecommendationsRequest`} requests.
   * @param title title or {@code null} for none
   */
  public Recommendation setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * Output only. Type of the recommendation. List of currently available recommendation types: -
   * OPPORTUNITY_CREATE_NEW_COLLECTION - OPPORTUNITY_CREATE_EMAIL_CAMPAIGN
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Output only. Type of the recommendation. List of currently available recommendation types: -
   * OPPORTUNITY_CREATE_NEW_COLLECTION - OPPORTUNITY_CREATE_EMAIL_CAMPAIGN
   * @param type type or {@code null} for none
   */
  public Recommendation setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Recommendation set(String fieldName, Object value) {
    return (Recommendation) super.set(fieldName, value);
  }

  @Override
  public Recommendation clone() {
    return (Recommendation) super.clone();
  }

}
