/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Call to action (CTA) that explains how a merchant can implement this recommendation
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RecommendationCallToAction extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Intent of the action. This value describes the intent (for example,
   * `OPEN_CREATE_EMAIL_CAMPAIGN_FLOW`) and can vary from recommendation to recommendation. This
   * value can change over time for the same recommendation. Currently available intent values: -
   * OPEN_CREATE_EMAIL_CAMPAIGN_FLOW: Opens a user journey where they can create a marketing email
   * campaign. (No default URL) - OPEN_CREATE_COLLECTION_TAB: Opens a user journey where they can
   * [create a collection](https://support.google.com/merchants/answer/9703228) for their Merchant
   * account. (No default URL)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String intent;

  /**
   * Output only. Localized text of the CTA. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String localizedText;

  /**
   * Optional. URL of the CTA. This field will only be set for some recommendations where there is a
   * suggested landing URL. Otherwise it will be set to an empty string. We recommend developers to
   * use their own custom landing page according to the description of the intent field above when
   * this uri field is empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uri;

  /**
   * Output only. Intent of the action. This value describes the intent (for example,
   * `OPEN_CREATE_EMAIL_CAMPAIGN_FLOW`) and can vary from recommendation to recommendation. This
   * value can change over time for the same recommendation. Currently available intent values: -
   * OPEN_CREATE_EMAIL_CAMPAIGN_FLOW: Opens a user journey where they can create a marketing email
   * campaign. (No default URL) - OPEN_CREATE_COLLECTION_TAB: Opens a user journey where they can
   * [create a collection](https://support.google.com/merchants/answer/9703228) for their Merchant
   * account. (No default URL)
   * @return value or {@code null} for none
   */
  public java.lang.String getIntent() {
    return intent;
  }

  /**
   * Output only. Intent of the action. This value describes the intent (for example,
   * `OPEN_CREATE_EMAIL_CAMPAIGN_FLOW`) and can vary from recommendation to recommendation. This
   * value can change over time for the same recommendation. Currently available intent values: -
   * OPEN_CREATE_EMAIL_CAMPAIGN_FLOW: Opens a user journey where they can create a marketing email
   * campaign. (No default URL) - OPEN_CREATE_COLLECTION_TAB: Opens a user journey where they can
   * [create a collection](https://support.google.com/merchants/answer/9703228) for their Merchant
   * account. (No default URL)
   * @param intent intent or {@code null} for none
   */
  public RecommendationCallToAction setIntent(java.lang.String intent) {
    this.intent = intent;
    return this;
  }

  /**
   * Output only. Localized text of the CTA. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocalizedText() {
    return localizedText;
  }

  /**
   * Output only. Localized text of the CTA. Optional.
   * @param localizedText localizedText or {@code null} for none
   */
  public RecommendationCallToAction setLocalizedText(java.lang.String localizedText) {
    this.localizedText = localizedText;
    return this;
  }

  /**
   * Optional. URL of the CTA. This field will only be set for some recommendations where there is a
   * suggested landing URL. Otherwise it will be set to an empty string. We recommend developers to
   * use their own custom landing page according to the description of the intent field above when
   * this uri field is empty.
   * @return value or {@code null} for none
   */
  public java.lang.String getUri() {
    return uri;
  }

  /**
   * Optional. URL of the CTA. This field will only be set for some recommendations where there is a
   * suggested landing URL. Otherwise it will be set to an empty string. We recommend developers to
   * use their own custom landing page according to the description of the intent field above when
   * this uri field is empty.
   * @param uri uri or {@code null} for none
   */
  public RecommendationCallToAction setUri(java.lang.String uri) {
    this.uri = uri;
    return this;
  }

  @Override
  public RecommendationCallToAction set(String fieldName, Object value) {
    return (RecommendationCallToAction) super.set(fieldName, value);
  }

  @Override
  public RecommendationCallToAction clone() {
    return (RecommendationCallToAction) super.clone();
  }

}
