/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Response containing support content and actions for listed product issues.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RenderProductIssuesResponse extends com.google.api.client.json.GenericJson {

  /**
   * The Alternate Dispute Resolution (ADR) contains a link to a page where merchant can bring their
   * appeal to an [external body](https://support.google.com/european-union-digital-services-act-
   * redress-options/answer/13535501). If present, the link should be shown on the same page as the
   * list of issues.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AlternateDisputeResolution alternateDisputeResolution;

  /**
   * List of issues for a given product. This list can be shown with compressed, expandable items.
   * In the compressed form, the title and impact should be shown for each issue. Once the issue is
   * expanded, the detailed content and available actions should be rendered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ProductIssue> issues;

  static {
    // hack to force ProGuard to consider ProductIssue used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ProductIssue.class);
  }

  /**
   * The Alternate Dispute Resolution (ADR) contains a link to a page where merchant can bring their
   * appeal to an [external body](https://support.google.com/european-union-digital-services-act-
   * redress-options/answer/13535501). If present, the link should be shown on the same page as the
   * list of issues.
   * @return value or {@code null} for none
   */
  public AlternateDisputeResolution getAlternateDisputeResolution() {
    return alternateDisputeResolution;
  }

  /**
   * The Alternate Dispute Resolution (ADR) contains a link to a page where merchant can bring their
   * appeal to an [external body](https://support.google.com/european-union-digital-services-act-
   * redress-options/answer/13535501). If present, the link should be shown on the same page as the
   * list of issues.
   * @param alternateDisputeResolution alternateDisputeResolution or {@code null} for none
   */
  public RenderProductIssuesResponse setAlternateDisputeResolution(AlternateDisputeResolution alternateDisputeResolution) {
    this.alternateDisputeResolution = alternateDisputeResolution;
    return this;
  }

  /**
   * List of issues for a given product. This list can be shown with compressed, expandable items.
   * In the compressed form, the title and impact should be shown for each issue. Once the issue is
   * expanded, the detailed content and available actions should be rendered.
   * @return value or {@code null} for none
   */
  public java.util.List<ProductIssue> getIssues() {
    return issues;
  }

  /**
   * List of issues for a given product. This list can be shown with compressed, expandable items.
   * In the compressed form, the title and impact should be shown for each issue. Once the issue is
   * expanded, the detailed content and available actions should be rendered.
   * @param issues issues or {@code null} for none
   */
  public RenderProductIssuesResponse setIssues(java.util.List<ProductIssue> issues) {
    this.issues = issues;
    return this;
  }

  @Override
  public RenderProductIssuesResponse set(String fieldName, Object value) {
    return (RenderProductIssuesResponse) super.set(fieldName, value);
  }

  @Override
  public RenderProductIssuesResponse clone() {
    return (RenderProductIssuesResponse) super.clone();
  }

}
