/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Request to report interactions on a recommendation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReportInteractionRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. Type of the interaction that is reported, for example INTERACTION_CLICK.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String interactionType;

  /**
   * Required. Token of the response when recommendation was returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String responseToken;

  /**
   * Optional. Subtype of the recommendations this interaction happened on. This field must be set
   * only to the value that is returned by {@link `RecommendationsService.GenerateRecommendations`}
   * call.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subtype;

  /**
   * Required. Type of the recommendations on which this interaction happened. This field must be
   * set only to the value that is returned by {@link `GenerateRecommendationsResponse`} call.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Required. Type of the interaction that is reported, for example INTERACTION_CLICK.
   * @return value or {@code null} for none
   */
  public java.lang.String getInteractionType() {
    return interactionType;
  }

  /**
   * Required. Type of the interaction that is reported, for example INTERACTION_CLICK.
   * @param interactionType interactionType or {@code null} for none
   */
  public ReportInteractionRequest setInteractionType(java.lang.String interactionType) {
    this.interactionType = interactionType;
    return this;
  }

  /**
   * Required. Token of the response when recommendation was returned.
   * @return value or {@code null} for none
   */
  public java.lang.String getResponseToken() {
    return responseToken;
  }

  /**
   * Required. Token of the response when recommendation was returned.
   * @param responseToken responseToken or {@code null} for none
   */
  public ReportInteractionRequest setResponseToken(java.lang.String responseToken) {
    this.responseToken = responseToken;
    return this;
  }

  /**
   * Optional. Subtype of the recommendations this interaction happened on. This field must be set
   * only to the value that is returned by {@link `RecommendationsService.GenerateRecommendations`}
   * call.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubtype() {
    return subtype;
  }

  /**
   * Optional. Subtype of the recommendations this interaction happened on. This field must be set
   * only to the value that is returned by {@link `RecommendationsService.GenerateRecommendations`}
   * call.
   * @param subtype subtype or {@code null} for none
   */
  public ReportInteractionRequest setSubtype(java.lang.String subtype) {
    this.subtype = subtype;
    return this;
  }

  /**
   * Required. Type of the recommendations on which this interaction happened. This field must be
   * set only to the value that is returned by {@link `GenerateRecommendationsResponse`} call.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Required. Type of the recommendations on which this interaction happened. This field must be
   * set only to the value that is returned by {@link `GenerateRecommendationsResponse`} call.
   * @param type type or {@code null} for none
   */
  public ReportInteractionRequest setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public ReportInteractionRequest set(String fieldName, Object value) {
    return (ReportInteractionRequest) super.set(fieldName, value);
  }

  @Override
  public ReportInteractionRequest clone() {
    return (ReportInteractionRequest) super.clone();
  }

}
