/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Request message for the RequestPhoneVerification method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RequestPhoneVerificationRequest extends com.google.api.client.json.GenericJson {

  /**
   * Language code [IETF BCP 47 syntax](https://tools.ietf.org/html/bcp47) (for example, en-US).
   * Language code is used to provide localized `SMS` and `PHONE_CALL`. Default language used is en-
   * US if not provided.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCode;

  /**
   * Phone number to be verified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String phoneNumber;

  /**
   * Required. Two letter country code for the phone number, for example `CA` for Canadian numbers.
   * See the [ISO 3166-1
   * alpha-2](https://wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements)
   * officially assigned codes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String phoneRegionCode;

  /**
   * Verification method to receive verification code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String phoneVerificationMethod;

  /**
   * Language code [IETF BCP 47 syntax](https://tools.ietf.org/html/bcp47) (for example, en-US).
   * Language code is used to provide localized `SMS` and `PHONE_CALL`. Default language used is en-
   * US if not provided.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCode() {
    return languageCode;
  }

  /**
   * Language code [IETF BCP 47 syntax](https://tools.ietf.org/html/bcp47) (for example, en-US).
   * Language code is used to provide localized `SMS` and `PHONE_CALL`. Default language used is en-
   * US if not provided.
   * @param languageCode languageCode or {@code null} for none
   */
  public RequestPhoneVerificationRequest setLanguageCode(java.lang.String languageCode) {
    this.languageCode = languageCode;
    return this;
  }

  /**
   * Phone number to be verified.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhoneNumber() {
    return phoneNumber;
  }

  /**
   * Phone number to be verified.
   * @param phoneNumber phoneNumber or {@code null} for none
   */
  public RequestPhoneVerificationRequest setPhoneNumber(java.lang.String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * Required. Two letter country code for the phone number, for example `CA` for Canadian numbers.
   * See the [ISO 3166-1
   * alpha-2](https://wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements)
   * officially assigned codes.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhoneRegionCode() {
    return phoneRegionCode;
  }

  /**
   * Required. Two letter country code for the phone number, for example `CA` for Canadian numbers.
   * See the [ISO 3166-1
   * alpha-2](https://wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements)
   * officially assigned codes.
   * @param phoneRegionCode phoneRegionCode or {@code null} for none
   */
  public RequestPhoneVerificationRequest setPhoneRegionCode(java.lang.String phoneRegionCode) {
    this.phoneRegionCode = phoneRegionCode;
    return this;
  }

  /**
   * Verification method to receive verification code.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhoneVerificationMethod() {
    return phoneVerificationMethod;
  }

  /**
   * Verification method to receive verification code.
   * @param phoneVerificationMethod phoneVerificationMethod or {@code null} for none
   */
  public RequestPhoneVerificationRequest setPhoneVerificationMethod(java.lang.String phoneVerificationMethod) {
    this.phoneVerificationMethod = phoneVerificationMethod;
    return this;
  }

  @Override
  public RequestPhoneVerificationRequest set(String fieldName, Object value) {
    return (RequestPhoneVerificationRequest) super.set(fieldName, value);
  }

  @Override
  public RequestPhoneVerificationRequest clone() {
    return (RequestPhoneVerificationRequest) super.clone();
  }

}
