/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Return policy online object. This is currently used to represent return policies for ads and free
 * listings programs.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReturnPolicyOnline extends com.google.api.client.json.GenericJson {

  /**
   * The countries of sale where the return policy is applicable. The values must be a valid 2
   * letter ISO 3166 code, e.g. "US".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> countries;

  /**
   * The item conditions that are accepted for returns. This is required to not be empty unless the
   * type of return policy is noReturns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> itemConditions;

  /**
   * The unique user-defined label of the return policy. The same label cannot be used in different
   * return policies for the same country. Policies with the label 'default' will apply to all
   * products, unless a product specifies a return_policy_label attribute.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * The name of the policy as shown in Merchant Center.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The return policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReturnPolicyOnlinePolicy policy;

  /**
   * The restocking fee that applies to all return reason categories. This would be treated as a
   * free restocking fee if the value is not set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReturnPolicyOnlineRestockingFee restockingFee;

  /**
   * The return methods of how customers can return an item. This value is required to not be empty
   * unless the type of return policy is noReturns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> returnMethods;

  /**
   * Output only. Return policy ID generated by Google.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String returnPolicyId;

  /**
   * The return policy uri. This can used by Google to do a sanity check for the policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String returnPolicyUri;

  /**
   * The return reason category information. This required to not be empty unless the type of return
   * policy is noReturns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ReturnPolicyOnlineReturnReasonCategoryInfo> returnReasonCategoryInfo;

  /**
   * The countries of sale where the return policy is applicable. The values must be a valid 2
   * letter ISO 3166 code, e.g. "US".
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getCountries() {
    return countries;
  }

  /**
   * The countries of sale where the return policy is applicable. The values must be a valid 2
   * letter ISO 3166 code, e.g. "US".
   * @param countries countries or {@code null} for none
   */
  public ReturnPolicyOnline setCountries(java.util.List<java.lang.String> countries) {
    this.countries = countries;
    return this;
  }

  /**
   * The item conditions that are accepted for returns. This is required to not be empty unless the
   * type of return policy is noReturns.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getItemConditions() {
    return itemConditions;
  }

  /**
   * The item conditions that are accepted for returns. This is required to not be empty unless the
   * type of return policy is noReturns.
   * @param itemConditions itemConditions or {@code null} for none
   */
  public ReturnPolicyOnline setItemConditions(java.util.List<java.lang.String> itemConditions) {
    this.itemConditions = itemConditions;
    return this;
  }

  /**
   * The unique user-defined label of the return policy. The same label cannot be used in different
   * return policies for the same country. Policies with the label 'default' will apply to all
   * products, unless a product specifies a return_policy_label attribute.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * The unique user-defined label of the return policy. The same label cannot be used in different
   * return policies for the same country. Policies with the label 'default' will apply to all
   * products, unless a product specifies a return_policy_label attribute.
   * @param label label or {@code null} for none
   */
  public ReturnPolicyOnline setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * The name of the policy as shown in Merchant Center.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the policy as shown in Merchant Center.
   * @param name name or {@code null} for none
   */
  public ReturnPolicyOnline setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The return policy.
   * @return value or {@code null} for none
   */
  public ReturnPolicyOnlinePolicy getPolicy() {
    return policy;
  }

  /**
   * The return policy.
   * @param policy policy or {@code null} for none
   */
  public ReturnPolicyOnline setPolicy(ReturnPolicyOnlinePolicy policy) {
    this.policy = policy;
    return this;
  }

  /**
   * The restocking fee that applies to all return reason categories. This would be treated as a
   * free restocking fee if the value is not set.
   * @return value or {@code null} for none
   */
  public ReturnPolicyOnlineRestockingFee getRestockingFee() {
    return restockingFee;
  }

  /**
   * The restocking fee that applies to all return reason categories. This would be treated as a
   * free restocking fee if the value is not set.
   * @param restockingFee restockingFee or {@code null} for none
   */
  public ReturnPolicyOnline setRestockingFee(ReturnPolicyOnlineRestockingFee restockingFee) {
    this.restockingFee = restockingFee;
    return this;
  }

  /**
   * The return methods of how customers can return an item. This value is required to not be empty
   * unless the type of return policy is noReturns.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getReturnMethods() {
    return returnMethods;
  }

  /**
   * The return methods of how customers can return an item. This value is required to not be empty
   * unless the type of return policy is noReturns.
   * @param returnMethods returnMethods or {@code null} for none
   */
  public ReturnPolicyOnline setReturnMethods(java.util.List<java.lang.String> returnMethods) {
    this.returnMethods = returnMethods;
    return this;
  }

  /**
   * Output only. Return policy ID generated by Google.
   * @return value or {@code null} for none
   */
  public java.lang.String getReturnPolicyId() {
    return returnPolicyId;
  }

  /**
   * Output only. Return policy ID generated by Google.
   * @param returnPolicyId returnPolicyId or {@code null} for none
   */
  public ReturnPolicyOnline setReturnPolicyId(java.lang.String returnPolicyId) {
    this.returnPolicyId = returnPolicyId;
    return this;
  }

  /**
   * The return policy uri. This can used by Google to do a sanity check for the policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getReturnPolicyUri() {
    return returnPolicyUri;
  }

  /**
   * The return policy uri. This can used by Google to do a sanity check for the policy.
   * @param returnPolicyUri returnPolicyUri or {@code null} for none
   */
  public ReturnPolicyOnline setReturnPolicyUri(java.lang.String returnPolicyUri) {
    this.returnPolicyUri = returnPolicyUri;
    return this;
  }

  /**
   * The return reason category information. This required to not be empty unless the type of return
   * policy is noReturns.
   * @return value or {@code null} for none
   */
  public java.util.List<ReturnPolicyOnlineReturnReasonCategoryInfo> getReturnReasonCategoryInfo() {
    return returnReasonCategoryInfo;
  }

  /**
   * The return reason category information. This required to not be empty unless the type of return
   * policy is noReturns.
   * @param returnReasonCategoryInfo returnReasonCategoryInfo or {@code null} for none
   */
  public ReturnPolicyOnline setReturnReasonCategoryInfo(java.util.List<ReturnPolicyOnlineReturnReasonCategoryInfo> returnReasonCategoryInfo) {
    this.returnReasonCategoryInfo = returnReasonCategoryInfo;
    return this;
  }

  @Override
  public ReturnPolicyOnline set(String fieldName, Object value) {
    return (ReturnPolicyOnline) super.set(fieldName, value);
  }

  @Override
  public ReturnPolicyOnline clone() {
    return (ReturnPolicyOnline) super.clone();
  }

}
