/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for ReturnPricingInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReturnPricingInfo extends com.google.api.client.json.GenericJson {

  /**
   * Default option for whether merchant should charge the customer for return shipping costs, based
   * on customer selected return reason and merchant's return policy for the items being returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean chargeReturnShippingFee;

  /**
   * Maximum return shipping costs that may be charged to the customer depending on merchant's
   * assessment of the return reason and the merchant's return policy for the items being returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MonetaryAmount maxReturnShippingFee;

  /**
   * Total amount that can be refunded for the items in this return. It represents the total amount
   * received by the merchant for the items, after applying merchant coupons.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MonetaryAmount refundableItemsTotalAmount;

  /**
   * Maximum amount that can be refunded for the original shipping fee.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MonetaryAmount refundableShippingAmount;

  /**
   * Total amount already refunded by the merchant. It includes all types of refunds (items,
   * shipping, etc.) Not provided if no refund has been applied yet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MonetaryAmount totalRefundedAmount;

  /**
   * Default option for whether merchant should charge the customer for return shipping costs, based
   * on customer selected return reason and merchant's return policy for the items being returned.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getChargeReturnShippingFee() {
    return chargeReturnShippingFee;
  }

  /**
   * Default option for whether merchant should charge the customer for return shipping costs, based
   * on customer selected return reason and merchant's return policy for the items being returned.
   * @param chargeReturnShippingFee chargeReturnShippingFee or {@code null} for none
   */
  public ReturnPricingInfo setChargeReturnShippingFee(java.lang.Boolean chargeReturnShippingFee) {
    this.chargeReturnShippingFee = chargeReturnShippingFee;
    return this;
  }

  /**
   * Maximum return shipping costs that may be charged to the customer depending on merchant's
   * assessment of the return reason and the merchant's return policy for the items being returned.
   * @return value or {@code null} for none
   */
  public MonetaryAmount getMaxReturnShippingFee() {
    return maxReturnShippingFee;
  }

  /**
   * Maximum return shipping costs that may be charged to the customer depending on merchant's
   * assessment of the return reason and the merchant's return policy for the items being returned.
   * @param maxReturnShippingFee maxReturnShippingFee or {@code null} for none
   */
  public ReturnPricingInfo setMaxReturnShippingFee(MonetaryAmount maxReturnShippingFee) {
    this.maxReturnShippingFee = maxReturnShippingFee;
    return this;
  }

  /**
   * Total amount that can be refunded for the items in this return. It represents the total amount
   * received by the merchant for the items, after applying merchant coupons.
   * @return value or {@code null} for none
   */
  public MonetaryAmount getRefundableItemsTotalAmount() {
    return refundableItemsTotalAmount;
  }

  /**
   * Total amount that can be refunded for the items in this return. It represents the total amount
   * received by the merchant for the items, after applying merchant coupons.
   * @param refundableItemsTotalAmount refundableItemsTotalAmount or {@code null} for none
   */
  public ReturnPricingInfo setRefundableItemsTotalAmount(MonetaryAmount refundableItemsTotalAmount) {
    this.refundableItemsTotalAmount = refundableItemsTotalAmount;
    return this;
  }

  /**
   * Maximum amount that can be refunded for the original shipping fee.
   * @return value or {@code null} for none
   */
  public MonetaryAmount getRefundableShippingAmount() {
    return refundableShippingAmount;
  }

  /**
   * Maximum amount that can be refunded for the original shipping fee.
   * @param refundableShippingAmount refundableShippingAmount or {@code null} for none
   */
  public ReturnPricingInfo setRefundableShippingAmount(MonetaryAmount refundableShippingAmount) {
    this.refundableShippingAmount = refundableShippingAmount;
    return this;
  }

  /**
   * Total amount already refunded by the merchant. It includes all types of refunds (items,
   * shipping, etc.) Not provided if no refund has been applied yet.
   * @return value or {@code null} for none
   */
  public MonetaryAmount getTotalRefundedAmount() {
    return totalRefundedAmount;
  }

  /**
   * Total amount already refunded by the merchant. It includes all types of refunds (items,
   * shipping, etc.) Not provided if no refund has been applied yet.
   * @param totalRefundedAmount totalRefundedAmount or {@code null} for none
   */
  public ReturnPricingInfo setTotalRefundedAmount(MonetaryAmount totalRefundedAmount) {
    this.totalRefundedAmount = totalRefundedAmount;
    return this;
  }

  @Override
  public ReturnPricingInfo set(String fieldName, Object value) {
    return (ReturnPricingInfo) super.set(fieldName, value);
  }

  @Override
  public ReturnPricingInfo clone() {
    return (ReturnPricingInfo) super.clone();
  }

}
