/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Time local delivery ends for the day based on the local timezone of the store.
 * `local_cutoff_time` and `store_close_offset_hours` are mutually exclusive.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ServiceStoreConfigCutoffConfig extends com.google.api.client.json.GenericJson {

  /**
   * Time in hours and minutes in the local timezone when local delivery ends.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ServiceStoreConfigCutoffConfigLocalCutoffTime localCutoffTime;

  /**
   * Merchants can opt-out of showing n+1 day local delivery when they have a shipping service
   * configured to n day local delivery. For example, if the shipping service defines same-day
   * delivery, and it's past the cut-off, setting this field to `true` results in the calculated
   * shipping service rate returning `NO_DELIVERY_POST_CUTOFF`. In the same example, setting this
   * field to `false` results in the calculated shipping time being one day. This is only for local
   * delivery.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean noDeliveryPostCutoff;

  /**
   * Represents cutoff time as the number of hours before store closing. Mutually exclusive with
   * other fields (hour and minute).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long storeCloseOffsetHours;

  /**
   * Time in hours and minutes in the local timezone when local delivery ends.
   * @return value or {@code null} for none
   */
  public ServiceStoreConfigCutoffConfigLocalCutoffTime getLocalCutoffTime() {
    return localCutoffTime;
  }

  /**
   * Time in hours and minutes in the local timezone when local delivery ends.
   * @param localCutoffTime localCutoffTime or {@code null} for none
   */
  public ServiceStoreConfigCutoffConfig setLocalCutoffTime(ServiceStoreConfigCutoffConfigLocalCutoffTime localCutoffTime) {
    this.localCutoffTime = localCutoffTime;
    return this;
  }

  /**
   * Merchants can opt-out of showing n+1 day local delivery when they have a shipping service
   * configured to n day local delivery. For example, if the shipping service defines same-day
   * delivery, and it's past the cut-off, setting this field to `true` results in the calculated
   * shipping service rate returning `NO_DELIVERY_POST_CUTOFF`. In the same example, setting this
   * field to `false` results in the calculated shipping time being one day. This is only for local
   * delivery.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getNoDeliveryPostCutoff() {
    return noDeliveryPostCutoff;
  }

  /**
   * Merchants can opt-out of showing n+1 day local delivery when they have a shipping service
   * configured to n day local delivery. For example, if the shipping service defines same-day
   * delivery, and it's past the cut-off, setting this field to `true` results in the calculated
   * shipping service rate returning `NO_DELIVERY_POST_CUTOFF`. In the same example, setting this
   * field to `false` results in the calculated shipping time being one day. This is only for local
   * delivery.
   * @param noDeliveryPostCutoff noDeliveryPostCutoff or {@code null} for none
   */
  public ServiceStoreConfigCutoffConfig setNoDeliveryPostCutoff(java.lang.Boolean noDeliveryPostCutoff) {
    this.noDeliveryPostCutoff = noDeliveryPostCutoff;
    return this;
  }

  /**
   * Represents cutoff time as the number of hours before store closing. Mutually exclusive with
   * other fields (hour and minute).
   * @return value or {@code null} for none
   */
  public java.lang.Long getStoreCloseOffsetHours() {
    return storeCloseOffsetHours;
  }

  /**
   * Represents cutoff time as the number of hours before store closing. Mutually exclusive with
   * other fields (hour and minute).
   * @param storeCloseOffsetHours storeCloseOffsetHours or {@code null} for none
   */
  public ServiceStoreConfigCutoffConfig setStoreCloseOffsetHours(java.lang.Long storeCloseOffsetHours) {
    this.storeCloseOffsetHours = storeCloseOffsetHours;
    return this;
  }

  @Override
  public ServiceStoreConfigCutoffConfig set(String fieldName, Object value) {
    return (ServiceStoreConfigCutoffConfig) super.set(fieldName, value);
  }

  @Override
  public ServiceStoreConfigCutoffConfig clone() {
    return (ServiceStoreConfigCutoffConfig) super.clone();
  }

}
